#include <iostream>
#include <fstream>
#include <string>
using namespace std;
#include <string.h>

// Diese Klasse nimmt die Zeichenkette im klassischen
// char-Array auf und enthlt damit die Daten.
class tDaten
{
public:
   void Set(char *para)
   {
        strncpy(data, para, sizeof(data));
        data[sizeof(data)-1] = 0;
   }
   void Show()
   {
       cout << data << endl;
   }
private:
    char data[255];
};

// Hier werden die C++-Strings verwendet. Allerdings enthlt
// eine Variable vom Typ string nicht die eigentlichen Daten.
class tStrDaten
{
public:
   void Set(char *para)
   {
       data = para;
   }
   void Show()
   {
       cout << data << endl;
   }
private:
    string data;
};

int main(int argc, char**argv)
{
  // tStrDaten Daten;  // Damit funktioniert es nicht!
  tDaten Daten;        // Damit funktioniert es!

  // Eine Datein namens testdatei wird erffnet
  fstream f("testdatei", ios::out|ios::binary|ios::in);

  // Wurde ein Parameter beim Aufruf bergeben?
  if (argc>=2)
  {
      Daten.Set(argv[1]); // In Daten ablegen
      // Objekt in Datei speichern
      f.write((char*)&Daten, sizeof(Daten));
  }
  // Kein Argument? Dann Datei auslesen!
  if (argc==1)
  {
      // Dateiinhalt in Variable lesen
      f.read((char *)&Daten, sizeof(Daten));
      Daten.Show(); // ... und anzeigen
  }
}

