#include <iostream>
using namespace std;

enum tToken {
    PLUS, MINUS, MUL, DIV, LPAR, RPAR, NUMBER, END, ERROR};

// Globale Variablen:
tToken aktToken;     // das zuletzt erkannte Token
double TokenZahlenWert; // der Wert bei Zahlenkonstanten

char *srcPos; // Programm-Position

void leseZahl()
{
    while (*srcPos>='0' && *srcPos<'9') {
        TokenZahlenWert *= 10;
        TokenZahlenWert += *srcPos-'0';
        srcPos++;
    }
    if (*srcPos==','||*srcPos=='.')
    {
        double NK = 1;
        srcPos++;
        while (*srcPos>='0' && *srcPos<='9')
        {
            NK *= 10;
            TokenZahlenWert += (*srcPos-'0')/NK;
            srcPos++;
        }
    }
}

tToken sucheToken()
// Sucht ab der aktuellen Stringposition das nchste Token.
// Hier werden auch die Zahlenkonstanten bestimmt und in
// der globalen Variablen TokenZahlenWert abgelegt.
{
    aktToken = ERROR;
    while (*srcPos==' ')
    {
        srcPos++;
    }
    if (*srcPos==0) {
        aktToken = END;
    } else {
        switch (*srcPos) {
        case '(': aktToken=LPAR;  break;
        case ')': aktToken=RPAR;  break;
        case '*': aktToken=MUL;   break;
        case '/': aktToken=DIV;   break;
        case '+': aktToken=PLUS;  break;
        case '-': aktToken=MINUS; break;
        }
        if (*srcPos>='0' && *srcPos<'9') {
            aktToken=NUMBER;
            TokenZahlenWert = 0.0;
            leseZahl();
        }
        if (aktToken != NUMBER) srcPos++;
    }
    return aktToken;
}

tToken Error(char *s)
// Meldung ausgeben und Fehler-Token zurckliefern
{
    cerr << s << endl;
    return ERROR;
}

double PlusMinus();

double Klammern()
// wertet Klammern, Zahlen und Vorzeichen aus
// ruft Klammern() und PlusMinus() dadurch rekursiv!
{
double Wert;

    switch(aktToken) {
    case NUMBER:
        sucheToken();
        return TokenZahlenWert;
    case MINUS:
        sucheToken();
        return -Klammern();
    case LPAR:
        sucheToken();
        Wert = PlusMinus();
        if (aktToken != RPAR)
           return Error(") expected");
        sucheToken();
        return Wert;
    case END:
        return 1;
    default:
        return Error("primary expected");
    }
}

double MulDiv()
// wertet Multiplikation und Division aus
// ruft Klammern(), dadurch rekursiv!
{
double Wert;

  // rufe erst die Operation mit der nchsthheren Prioritt
  Wert = Klammern();
  while (aktToken==MUL || aktToken==DIV) {
    if (aktToken==MUL) {
      sucheToken();
      Wert *= Klammern();
    } else if (aktToken==DIV) {
      sucheToken();
      Wert /= Klammern();
    }
  }
  return Wert;
}

double PlusMinus()
// wertet Summe und Differenz aus
// ruft MulDiv(), dadurch rekursiv
{
double Wert;

  // rufe erst die Operation mit der nchsthheren Prioritt
  Wert = MulDiv();
  while (aktToken==PLUS || aktToken==MINUS) {
    if (aktToken==PLUS) {
      sucheToken();
      Wert += MulDiv();
    } else if (aktToken==MINUS) {
      sucheToken();
      Wert -= MulDiv();
    }
  }
  return Wert;
}

double Auswertung(char *s)
{
    srcPos = s;
    sucheToken();   // bestimme schon einmal das erste Token vorweg
    return PlusMinus();
}

int main(int argc, char* argv[])
{
    if (argc!=2) {
         cout << "Mathematischer Ausdruck als zweiten Paramter ohne Leerzeichen"
              << endl;
         return 1;
    } else {
        double Wert = Auswertung(argv[1]);
        cout << Wert << endl;
    }
    return 0;
}

