#include <iostream>
#include <exception>
#include <string>
#include <sstream>
using namespace std;

// Meine eigene Basisklasse, abgeleitet von exception
class meaCulpa : public exception
{
public:
    meaCulpa(string s) {this->s = s;}
    virtual ~meaCulpa() throw() {}
    virtual const char * what() const throw()
        {return s.c_str();}
private:
    string s;
};

// Besonderer Fehler, wenn keine Daten mehr vorliegen
class KeineDatenMehr : public meaCulpa
{
public:
    KeineDatenMehr(int a) : meaCulpa(" ") {nr = a;}
    virtual ~KeineDatenMehr() throw() {}
    virtual const char * what() const throw();
private:
    int nr;
    string s;
};

// what() wird fr eigene Fehlermeldung berschrieben
const char * KeineDatenMehr::what() const throw()
{
  ostringstream getNr;
  getNr << "Keine Daten mehr. Fehlernr.: " << nr;
  return getNr.str().c_str();
}

// Eine weitere Fehlerart wird von meaCulpa abgeleitet.
class QuelleFehlt : public meaCulpa
{
public:
    QuelleFehlt() : meaCulpa("Quelle fehlt") {}
};

// Tuwas simuliert die beiden Fehlerarten in Abhngigkeit vom
// Parameter
void Tuwas(int Problem) throw (KeineDatenMehr, QuelleFehlt)
{
    if (Problem==0)
    {
        throw KeineDatenMehr(8);
    }
    if (Problem==1)
    {
        throw QuelleFehlt();
    }
}

int main()
{
    // Problem-Nummer eingeben
    int Auswahl;
    cout << "Zahl zwischen 0 und 3 eingeben:" << endl;
    cin >> Auswahl;
    // Der try-Block fngt die Exception in Tuwas
    try
    {
        Tuwas(Auswahl);
    }
    // Fngt nur die eigenen Fehler
    catch(meaCulpa& fehler)
    {
        cout << fehler.what() << endl;
    }
}

