#include <iostream>
using namespace std;
#include <stdlib.h>

const int X=9;
const int Y=7;
const int MaxSchiff=4;

struct tSchiff
{
    int x;
    int y;
    bool gefunden;
};


void zeigeSpielFeld(char SpielFeld[X][Y])
{
int x, y;

        cout << "     1  2  3  4  5  6  7  8  9" << endl;
        for (y=0; y<Y; y++)
        {
            cout << (char)('A'+y) << "  ";
            for (x=0; x<X; x++)
            {
                cout << "  " << SpielFeld[x][y] ;
            }
            cout << endl;
        }
}

void initAnzeige(char SpielFeld[X][Y])
{
int x, y;

    for (x=0; x<X; x++)
    {
        for (y=0; y<Y; y++)
        {
            SpielFeld[x][y] = '.';
        }
    }
}

void initSchiffe(tSchiff Schiff[])
{
int i, j;
bool neueZahl;

    srand(0);
    for(i=0; i<MaxSchiff; i++)
    {
        Schiff[i].gefunden = false;
        do
        {
            Schiff[i].x = rand() % X;
            Schiff[i].y = rand() % Y;
            neueZahl = true;
            for (j=0; j<i; j++)
            {
                if (Schiff[j].x==Schiff[i].x
                   && Schiff[j].y==Schiff[i].y)
                {
                    neueZahl = false;
                }
            }
        } while (!neueZahl);
    }
    for (i=0; i<MaxSchiff; i++)
    {
        cout << Schiff[i].x << "," << Schiff[i].y << " ";
    }
    cout << endl;
}

void initSpielFeld(char SpielFeld[X][Y], tSchiff Schiff[])
{
    initAnzeige(SpielFeld);
    initSchiffe(Schiff);
}

bool istHierEinSchiff(tSchiff Schiff[], int x, int y,
                      bool markieren=false)
// Diese Funktion ermittelt, ob an der aktuellen Position
// ein Schiff ist. Wird der letzte Parameter auf true
// gesetzt, wird das Schiff auf gefunden gesetzt.
{
    for (int i=0; i<MaxSchiff; i++)
    {
        if (Schiff[i].x==x && Schiff[i].y==y)
        {
            if (markieren)
            {
                Schiff[i].gefunden = true;
            }
            return true;
        }
    }
    return false;
}

int suche(tSchiff Schiff[], int x, int y, int xdiff, int ydiff)
{
    x+=xdiff;
    y+=ydiff;
    while(x<X && x>=0 && y<Y && y>=0)
    {
        if (istHierEinSchiff(Schiff, x, y))
        {
            return 1;
        }
        x+=xdiff;
        y+=ydiff;
    }
    return 0;
}

int sucheSchiffe(tSchiff Schiff[], int x, int y)
{
int Anzahl=0;

    if (istHierEinSchiff(Schiff, x, y, true))
    {
        return MaxSchiff;
    }
    else
    {
        for (int i=-1; i<=1; i++)
        {
            for (int j=-1; j<=1; j++)
            {
                if (!(i==0 && j==0))
                {
                    Anzahl += suche(Schiff, x, y, i, j);
                }
            }
        }
    }
    return Anzahl;
}


void Benutzereingabe(int *x, int *y)
{
char cx, cy;

    cin >> cx >> cy;
    *x = cx - '1';
    *y = cy - 'A';
}

bool SpielEnde(tSchiff Schiff[])
{
    for(int i=0; i<MaxSchiff; i++)
    {
        if (!Schiff[i].gefunden)
        {
            return false;
        }
    }
    return true;
}

void Eintragen(char SpielFeld[X][Y], int x, int y, int Anzahl)
{
    SpielFeld[x][y] = Anzahl>=MaxSchiff ? 'X' : '0'+Anzahl;
}

int main()
{
tSchiff Schiff[MaxSchiff];
char SpielFeld[X][Y];
int x, y;
int Anzahl;

    initSpielFeld(SpielFeld, Schiff);
    do
    {
        zeigeSpielFeld(SpielFeld);
        Benutzereingabe(&x, &y);
        Anzahl = sucheSchiffe(Schiff, x, y);
        Eintragen(SpielFeld, x, y, Anzahl);
    }
    while (!SpielEnde(Schiff));
}

