#include "field.h"

#include <iostream>
using namespace std;
#include <stdlib.h>

tField::tField()
{
	int i, j;
	int x, y;

	srand(12);
	i=0;
	while (i<MaxShips) 
	{
		x = rand() % MaxX + 1;
		y = rand() % MaxY + 1;
		
		for (j=0; j<i; j++)
		{
			if (Ship[j].GetX()==x && Ship[j].GetY()==y)
			{
				// Die Schiffe sind gleich, wir brauchen ein
				// Neues!
				i--;
				break;
			}
		}
		Ship[i].SetXY(x,y);
		i++;
	}
	for(i=0; i<MaxX; i++)
	{
		for (j=0; j<MaxY; j++)
		{
			Water[i][j] = '+';
		}
	}
}

tField::~tField()
{
}


int tField::TryThis(int px, int py)
{ // ist hier etwas?
	int i;
	
	for (i=0; i<MaxShips; i++) 
	{
		if (Ship[i].GetX()==px && Ship[i].GetY()==py) 
		{
			return i+1;
		}
	}
	return 0;
}

int tField::WalkLine(int px, int py, int dx, int dy)
{ // laufe eine Linie entlang
	if (dx==0 && dy==0) return 0;
	while (px>=0 && px<MaxX && py>=0 && py<MaxY) 
	{
		px += dx;
		py += dy;
		if (TryThis(px, py)>0) return 1;
	}
	return 0;		
}


int tField::AskPos(int px, int py)
{
	int i, j;
	int count=0;

	// haben wir bereits ein Schiff getroffen?
	count = TryThis(px, py);
	if (count>0) {
		Water[px][py] = '*';
		Ship[count-1].FoundIt();
		return SHIP;
	}

	// suche in alle Richtungen
	for (i=-1; i<=1; i++) {
		for (j=-1; j<=1; j++) {
			count += WalkLine(px, py, i, j);
		}
	}

	Water[px][py] = (char)('0'+count);
	return count;
}



void tField::ShowField()
{
	int i, j;

	cout << "   ";
	for (i=0; i<MaxX; i++)
	{
		cout << (char)('A'+i) <<" " ;
	}
	cout << endl;

	for (j=0; j<MaxY; j++)
	{
		cout << j+1 << "  ";
		for(i=0; i<MaxX; i++)
		{
			cout << Water[i][j] << " ";
		}
		cout << endl;
	}
}

bool tField::IsWon()
{
	bool won = true;

	for (int i=0; i<MaxShips; i++) 
	{
		if (!Ship[i].isFound())
		{
			won = false;
		}
	}
	return won;
}
