#include "tabelle.h"

#include <iostream>
#include <string>
#include <fstream>
#include <map>
using namespace std;


// laedt die Uebersetzungstabelle aus einer Datei.
// In jeder Zeile steht die Uebersetzung, ein Leerzeichen
// und dann das C++ Schluesselwort
void tTabelle::ladeDatei(const char *Dateiname)
{
    fstream f;
    f.exceptions(ios::failbit|ios::badbit|ios::eofbit);
    string str;
    try {
        f.open(Dateiname);
    } catch(ios_base::failure& fehler) {
        cout << "Datei konnte nicht geöffnet werden." 
             << endl;
        return;
    }
    try {
        while (! f.eof() ) {
            getline(f, str); // zeilenweise lesen
            unsigned long pos = str.find(" ", 0);
            if (pos != string::npos) {
                // Leerzeichen existiert
                string neu = str.substr(0, pos);
                // ueberlese alle vorhandenen Leerzeichen
                while (str[pos]==' ' && pos<str.length()) {
                    pos++;
                }
                // Rest der Zeile ist der Schluessel
                string alt = str.substr(pos);
                // Einfuegen in die map
                Uebersetzung[alt] = neu;
            }
        }
        f.close();
    } catch(ios_base::failure& fehler) {
        if (f.eof()) return;
        if (f.fail()) cout << "fail: ";
        if (f.bad()) cout << "bad: ";
        cout << fehler.what() << endl;
    }
}

// liefert die Uebersetzung zu einem Schluessel falls
// vorhanden, ansonsten einen leeren String
string tTabelle::getUebersetzung(string wort)
{
    map<string,string>::iterator it;
    it = Uebersetzung.find(wort);
    if (it==Uebersetzung.end()) {
        return "";
    } else {
         return it->second;
    }
}

// erzeugt eine Headerdatei mit #define-Statements, die es
// ermoeglicht, Programme in der Sprache zu uebersetzen.
void tTabelle::createHeader()
{
    map<string,string>::iterator it = Uebersetzung.begin();
    while (it!=Uebersetzung.end()) {
        cout << "#define " << it->second << " " << it->first << endl;
        ++it;
   }
}

