#include <iostream>
#include <string>
#include <fstream>
#include <map>
using namespace std;

#include "tabelle.h"

tTabelle Tabelle;

// Klein- oder Grossbuchstabe oder Unterstrich?
bool istIdentStart(char z)
{
    return (z>='a' && z<='z')
           || (z>='A' && z<='Z')
           || (z=='_') ;
}

bool istKonstante = false;

// Durchsuche Zeile nach Schluesselwoertern mit Zeiger
void scan(char *pPos)
{
    char *pZeilenstart = pPos; // fuer die spaetere Ausgabe
    while (*pPos) { // wird 0 am Ende der Zeile
        if (istKonstante) {
            while (*pPos && *pPos!='*') ++pPos;
            if (*pPos=='*') {
                ++pPos;
                if (*pPos=='/') {
                   istKonstante = false;
                }
            }
        } else if (istIdentStart(*pPos)) {
            char *pBezeichner = pPos; // Bezeichneranfang
            // suche nun das Ende des Bezeichners
            pPos++;
            while (istIdentStart(*pPos)
               || (*pPos>='0' && *pPos<='9')) {
                pPos++;
            }
            // wir stehen hinter dem Bezeichner
            // Das Zeichen sichern und durch 0 ersetzen
            char Sicher = *pPos;
            *pPos=0; // Endemarke fuer die find-Funktion
            string uebersetzt = Tabelle.getUebersetzung(pBezeichner);
            if (uebersetzt!="") {
                *pBezeichner = 0; // Begrenze die bisherige Zeile
                cout << pZeilenstart; // ... und gebe sie aus.
                // cout << it->second; // zeig die Uebersetzung
                cout << uebersetzt; // zeig die Uebersetzung
                pZeilenstart = pPos; // ab hier wieder aufsetzen
            }
            *pPos = Sicher;
        } else if (*pPos=='"') { // Stringkonstante
            ++pPos;
            while (*pPos && *pPos!='"') ++pPos;
            if (*pPos==0) break; // Stringende fehlt!
        } else if (*pPos=='/') {
            pPos++;
            if (*pPos=='/') break; // Restzeile Kommentar
            if (*pPos=='*') {
                istKonstante = true;
            }
        }
        pPos++;
    }
    // Rest der Zeile ausgeben
    cout << pZeilenstart << endl;
}

// Durchsuche Zeile nach Schluesselwoertern mit String
void scan(string Zeile)
{
    unsigned long Pos = 0;
    unsigned long Zeilenstart = 0;
    while (Pos<Zeile.length()) {
        if (istKonstante) {
            while (Pos<Zeile.length() && Zeile[Pos]!='*') ++Pos;
            if (Zeile[Pos]=='*') {
                ++Pos;
                if (Zeile[Pos]=='/') {
                   istKonstante = false;
                }
            }
        } else if (istIdentStart(Zeile[Pos])) {
            unsigned long Bezeichner = Pos;
            // suche Ende des Bezeichners
            Pos++;
            while (istIdentStart(Zeile[Pos])
               || (Zeile[Pos]>='0' && Zeile[Pos]<='9')) {
                Pos++;
            }
            // wir stehen hinter dem Bezeichner
            string uebersetzt=Tabelle.getUebersetzung(
                                    Zeile.substr(Bezeichner,
                                    Pos-Bezeichner));
            if (uebersetzt!="") {
                // den unuebersetzten Teil ausgeben
                cout << Zeile.substr(Zeilenstart,
                                     Bezeichner-Zeilenstart);
                // und die Uebersetzung des Schluesselworts
                cout << uebersetzt;
                // An dieser Stelle fortfahren
                Zeilenstart = Pos;
            }
        } else if (Zeile[Pos]=='"') { // Stringkonstante
            ++Pos;
            while (Pos<Zeile.length() && Zeile[Pos]!='"') ++Pos;
            if (Pos>=Zeile.length()) break; // Stringende fehlt!
        } else if (Zeile[Pos]=='/') {
            Pos++;
            if (Zeile[Pos]=='/') break; // Restzeile Kommentar
            if (Zeile[Pos]=='*') {
                istKonstante = true;
            }
        }
        Pos++;
    }
    // unbearbeiteten Teil der Zeile ausgeben
    cout << Zeile.substr(Zeilenstart) << endl;
}


void uebersetze(char *Dateiname)
{
    fstream f;
    // entkommentieren fuer Zeigervariante
    // char str[1024];
    // entkommentieren fuer Stringvariante
    string str;
    f.open(Dateiname);
    while (! f.eof() ) {
        // entkommentieren fuer Zeigervariante
        // f.getline(str, sizeof(str));
        // entkommentieren fuer Stringvariante
        getline(f, str);
        // hier sucht sich C++ die richtige Version selbst
        scan(str);
    }
    f.close();
}

int main(int argc, char **argv)
{
    // lade die Uebersetzungssprache
    if (argc>2) {
        Tabelle.ladeDatei(argv[2]);
    } else {
        Tabelle.ladeDatei("hessisch");
    }
    // starte die Uebersetzung
    if (argc>1) {
        uebersetze(argv[1]);
    }
}

