#include <iostream>
using namespace std;

#include "portaudio.h"

const unsigned long FRAMES_PER_BUFFER = 256;

typedef struct
{
    float LinkePhase;
    float RechtePhase;
} tPhaserData;

static int meinCallback(const void *inputBuffer,
                        void *outputBuffer,
                        unsigned long framesPerBuffer,
                        const PaStreamCallbackTimeInfo* TI,
                        PaStreamCallbackFlags statusFlags,
                        void *userData)
{
    // Die Userdaten werden ins Originalformat gebracht
    tPhaserData *Data = (tPhaserData*)userData; 
    float *out = (float*)outputBuffer;
    for (unsigned int i=0; i<framesPerBuffer; i++ ) {
        *out++ = Data->LinkePhase;
        *out++ = Data->RechtePhase;
        // Wir generieren einen einfachen Saegezahnphaser,
        // der zwischen -1.0 und 1.0 laeuft.
        Data->LinkePhase += 0.01f;
        // Wenn das Signal oben ist, ziehe es nach unten.
        if( Data->LinkePhase >= 1.0f ) {
            Data->LinkePhase -= 2.0f;
        }
        // Rechts hoehere Stimmlage, zur Unterscheidung
        Data->RechtePhase += 0.03f;
        if( Data->RechtePhase >= 1.0f ){
            Data->RechtePhase -= 2.0f;
        }
    }
    return 0;
}

static tPhaserData Data;

const long SAMPLE_RATE=44100;
const long NUM_SECONDS=1;


bool istFehler(PaError err)
{
    if (err==paNoError) return false; 
    cerr << "PortAudio error: " << Pa_GetErrorText(err)
         << endl;
    return true;
}

int main()
{
    PaStream *stream;
    PaError FehlerNr;

    FehlerNr = Pa_Initialize();
    if (istFehler(FehlerNr)) return 1;

    FehlerNr = Pa_OpenDefaultStream(
            &stream,
            0,   // Input-Kanaele
            2,   // Output-Kanaele
            paFloat32,  // Das Ausgabeformat
            SAMPLE_RATE,
            FRAMES_PER_BUFFER,
            meinCallback,
            &Data);
    if (istFehler(FehlerNr)) return 2;

    FehlerNr = Pa_StartStream(stream);
    if (istFehler(FehlerNr)) return 3;

    // Eine Runde schlafen, waehrend der Computer musiziert
    Pa_Sleep(NUM_SECONDS*1000);

    FehlerNr = Pa_StopStream(stream);
    if (istFehler(FehlerNr)) return 4;

    FehlerNr = Pa_CloseStream(stream);
    if (istFehler(FehlerNr)) return 5;

    FehlerNr = Pa_Terminate();
    if (istFehler(FehlerNr)) return 6;
}

