#include <iostream>
using namespace std;

#include <portaudio.h>
	
const int SampleRate=44100;
const int Sekunden=1;
const int SekundenBruchteil=10;
const int Kanaele=2;

#define PA_SAMPLE_TYPE  paInt16
typedef short SAMPLE;
const SAMPLE Stille=0;

class tEingang {
public:
    int     FramePos;
    int     MaxFramePos;
    SAMPLE  *Aufnahme;
};

static int recordCallback(const void *inputBuffer,
                          void *outputBuffer,
                          unsigned long framesPerBuffer,
                          const PaStreamCallbackTimeInfo* timeInfo,
                          PaStreamCallbackFlags statusFlags,
                          void *userData )
{
    tEingang *Eingang = (tEingang*)userData;
    SAMPLE *rptr = (SAMPLE*)inputBuffer;
    SAMPLE *wptr = &Eingang->Aufnahme[Eingang->FramePos * Kanaele];
    long framesToRecord;
    long i;
    int finished;
    unsigned long framesLeft = Eingang->MaxFramePos - Eingang->FramePos;
    int samplesToRecord;

    if (framesLeft < framesPerBuffer ) {
        framesToRecord = framesLeft;
        finished = 1;
    } else {
        framesToRecord = framesPerBuffer;
        finished = 0;
    }
   
    samplesToRecord = framesToRecord * Kanaele;
   
    if (inputBuffer == 0 ) {
        for (i=0; i<samplesToRecord; i++ ) {
            *wptr++ = Stille;
        }
    } else {
        for (i=0; i<samplesToRecord; i++ ) {
            *wptr++ = *rptr++;
        }
    }
    Eingang->FramePos += framesToRecord;
    return finished;
}

void checkError(int err)
{
    if (err==paNoError) return;
    Pa_Terminate();
    cerr << "An error occured while using the portaudio stream";
    cerr << "Error number: " << err ;
    cerr << "Error message: " << Pa_GetErrorText(err) << endl;
}


int main(void)
{
    PaStream *stream;
    PaError    err;
    tEingang Eingang;
    int        GesamtFrames;
    int        numSamples;
    SAMPLE     Amplitude, Signal;

    GesamtFrames = Sekunden * SampleRate;
    numSamples = GesamtFrames * Kanaele;

    Eingang.Aufnahme = new SAMPLE[numSamples];

   checkError(Pa_Initialize());

   // Erzeuge einen Stream fuer die Aufnahme
   err = Pa_OpenDefaultStream(
            &stream,
            Kanaele,          // input Kanaele
            0,          // output Kanaele
            PA_SAMPLE_TYPE,
            SampleRate,
            256,        // frames per buffer
            recordCallback,
            &Eingang);
   checkError(err);

    while (true) {
        Eingang.MaxFramePos = GesamtFrames;
        Eingang.FramePos = 0;
    
        checkError(Pa_StartStream(stream));
        cout << "Now recording!!" << endl;

        Pa_Sleep(1000/SekundenBruchteil); // Eine zehntel Sekunde pausieren

        checkError(Pa_StopStream(stream));

        Amplitude = 0;
        int Vorzeichen = +1;
        long Wechsel = 0;
        for (int i=0; i<Eingang.FramePos; i++ ) {
            Signal = Eingang.Aufnahme[i];
            if (Signal < 0 ) {
                if (Vorzeichen>0) {
                    Wechsel++;
                    Vorzeichen=-1;
                }
            } else if (Vorzeichen<0) {
                Wechsel++;
                Vorzeichen=1;
            }
            if (Signal > Amplitude ) {
                Amplitude = Signal;
            }
        }
        long Frequenz = SekundenBruchteil * Wechsel/2;

        cout << "Frequenz: " << Frequenz;
        cout << " Maximale Amplitude:" << Amplitude << endl;

    }
    checkError(Pa_CloseStream(stream));

    delete[] Eingang.Aufnahme;

    Pa_Terminate();
    return 0;
}

