#include <iostream>
using namespace std;

#include <portaudio.h>

const int SampleRate=44100;
const int Sekunden=1;
const int Kanaele=1;

#define PA_SAMPLE_TYPE  paInt16
typedef short SAMPLE;
const SAMPLE SCHWEIGEN=0;

class tAufnahme {
public:
    int    FramePos;
    int    MaxFrameIndex;
    SAMPLE *Samples;
};

static int recordCallback(const void *inputBuffer,
                          void *outputBuffer,
                          unsigned long framesPerBuffer,
                          const PaStreamCallbackTimeInfo* timeInfo,
                          PaStreamCallbackFlags statusFlags,
                          void *userData )
{
    tAufnahme *Aufnahme = (tAufnahme*)userData;
    SAMPLE *rptr = (SAMPLE*)inputBuffer;
    // Die Schreibposition wird am Ende der bisherigen
    // Aufnahme aufgesetzt
    SAMPLE *wptr 
        = &Aufnahme->Samples[Aufnahme->FramePos * Kanaele];
    long framesToRecord;
    int fertig;
    unsigned long RestFrames
        = Aufnahme->MaxFrameIndex - Aufnahme->FramePos;
    int samplesToRecord;
    if (RestFrames < framesPerBuffer) {
        framesToRecord = RestFrames;
        fertig = 1;
    } else {
        framesToRecord = framesPerBuffer;
        fertig = 0;
    }
    samplesToRecord = framesToRecord * Kanaele;
    if (inputBuffer==0) {
        for (long i=0; i<samplesToRecord; i++) {
            *wptr++ = SCHWEIGEN;
        }
    } else {
        for (long i=0; i<samplesToRecord; i++) {
            *wptr++ = *rptr++;
        }
    }
    Aufnahme->FramePos += framesToRecord;
    return fertig;
}

void checkError(int err)
{
    if (err==paNoError) return;
    Pa_Terminate();
    cerr << "An error occured while using the portaudio stream";
    cerr << "Error number: " << err ;
    cerr << "Error message: " << Pa_GetErrorText(err) << endl;
}


int main(void)
{
    PaStream   *Stream;
    PaError    err;
    tAufnahme  Aufnahme;
    int        GesamtFrames;
    int        AnzahlSamples;
    SAMPLE     MaxAmplitude, Wert;

    GesamtFrames = Sekunden * SampleRate;
    AnzahlSamples = GesamtFrames * Kanaele;

    Aufnahme.Samples = new SAMPLE[AnzahlSamples];

    Aufnahme.MaxFrameIndex = GesamtFrames;
    for(int i=0; i<AnzahlSamples; i++) Aufnahme.Samples[i] = 0;
    checkError(Pa_Initialize());

    // Bereite den Stream vor
    err = Pa_OpenDefaultStream(
            &Stream,
            1,          // input Kanaele
            0,          // output Kanaele
            PA_SAMPLE_TYPE,
            SampleRate,
            256,        // frames per buffer
            recordCallback,
            &Aufnahme );
    checkError(err);

    int MaxAlt=0;
    cout << "Schrei mal!!" << endl;
    int Runde=0;
    while (true) {

        Aufnahme.FramePos = 0;
        checkError(Pa_StartStream(Stream));
        Pa_Sleep(100); // Eine zehntel Sekunde pausieren
        checkError(Pa_StopStream(Stream));

        // Measure maximum peak amplitude.
        MaxAmplitude = 0;
        for(int i=0; i<AnzahlSamples; i++) {
            Wert = Aufnahme.Samples[i];
            if (Wert < 0 ) {
                Wert = -Wert; // Betrag
            }
            if (Wert > MaxAmplitude ) {
                MaxAmplitude = Wert;
            }
        }

        if (MaxAmplitude<1000) {
             MaxAmplitude=0; // Rauschen wegnehmen
        } else {
             Runde++;
        }

        cout << "Maximale Amplitude = " << MaxAmplitude << endl;
        if (MaxAmplitude<MaxAlt) break;
        MaxAlt = MaxAmplitude;
    }
    cout << "Danke, es reicht!" << endl;
    cout << "Runden: " << Runde << " Max. Amplitude: "
         << MaxAmplitude << endl;
    checkError(Pa_CloseStream(Stream));

    delete[] Aufnahme.Samples;

    Pa_Terminate();
    return 0;
}

