#include <iostream>
using namespace std;

#include <portaudio.h>

const int SampleRate=44100;
const int DauerInSekunden=5;
const int AnzahlKanaele=2;
const int FramePufferRate=256;

#define PA_SAMPLE_TYPE  paInt16
typedef short SAMPLE;
#define SAMPLE_SILENCE  (0)

class tAufnahmeDaten {
public:
    int    FrameIndex;  // Index des Aufnahme-Arrays
    int    MaxFrameIndex;
    SAMPLE *AufnahmeSamples;
};


static int recordCallback(const void *inputBuffer,
                          void *outputBuffer,
                          unsigned long FramesProPuffer,
                          const PaStreamCallbackTimeInfo* TimeInfo,
                          PaStreamCallbackFlags statusFlags,
                          void *userData )
{
    tAufnahmeDaten *Data = (tAufnahmeDaten*)userData;
    SAMPLE *rptr = (SAMPLE*)inputBuffer;
    SAMPLE *wptr = &Data->AufnahmeSamples[Data->FrameIndex * AnzahlKanaele];
    long framesToRecord;
    int Rueckgabe;
    unsigned long RestFrames = Data->MaxFrameIndex - Data->FrameIndex;
    int samplesToRecord;

    if (RestFrames<FramesProPuffer) {
        framesToRecord = RestFrames;
        Rueckgabe = 1; // entspricht true;
    } else {
        framesToRecord = FramesProPuffer;
        Rueckgabe = 0; // entspricht false;
    }

    samplesToRecord = framesToRecord * AnzahlKanaele;
 
    if (inputBuffer==0) {
        for (int i=0; i<samplesToRecord; i++) {
            *wptr++ = SAMPLE_SILENCE;
        }
    } else {
        for (int i=0; i<samplesToRecord; i++) {
            *wptr++ = *rptr++;
        }
    }
    Data->FrameIndex += framesToRecord;
    return Rueckgabe;
}

static int playCallback(const void *inputBuffer, 
                        void *outputBuffer,
                        unsigned long FramesProPuffer,
                        const PaStreamCallbackTimeInfo* TimeInfo,
                        PaStreamCallbackFlags statusFlags,
                        void *userData )
{
    tAufnahmeDaten *Data = (tAufnahmeDaten*)userData;
    SAMPLE *rptr = &Data->AufnahmeSamples[Data->FrameIndex * AnzahlKanaele];
    SAMPLE *wptr = (SAMPLE*)outputBuffer;
    int Rueckgabe;
    unsigned int RestFrames = Data->MaxFrameIndex - Data->FrameIndex;
    int framesToPlay, samplesToPlay, samplesPerBuffer;

    if (RestFrames<FramesProPuffer) {
        framesToPlay = RestFrames;
        Rueckgabe = 1; // entspricht true
    } else {
        framesToPlay = FramesProPuffer;
        Rueckgabe = 0; // entspricht false
    }

    samplesToPlay = framesToPlay * AnzahlKanaele;
    samplesPerBuffer = FramesProPuffer * AnzahlKanaele;

    int i; // muss vor der Schleife definiert sein!
    for (i=0; i<samplesToPlay; i++) {
        *wptr++ = *rptr++;
    }
    for (; i<FramesProPuffer; i++ ) {
        *wptr++ = 0;  // links
        if (AnzahlKanaele==2) *wptr++ = 0;  // rechts
    }
    Data->FrameIndex += framesToPlay;
    return Rueckgabe;
}

// Schreibe die aufgenommenen Daten in eine Datei
void Sichern(tAufnahmeDaten &Data, int GesamtzahlFrames)
{
    FILE  *fid;
    fid = fopen("audio.raw", "wb");
    if( fid == NULL ) {
        cerr << "Fehler beim Anlegen der Datei" << endl;
    } else {
        fwrite(Data.AufnahmeSamples,
               AnzahlKanaele * sizeof(SAMPLE),
               GesamtzahlFrames, fid);
        fclose( fid );
        cout << "Daten unter audio.raw gesichert" << endl;
    }
}

void pruefeFehler(int FehlerNr)
{
    if (FehlerNr==paNoError) return;
    Pa_Terminate();
    cerr << "Fehlernummer: " << FehlerNr;
    cerr << " Meldung: " << Pa_GetErrorText(FehlerNr) << endl;
}

int main()
{
    PaStream       *Stream;
    PaError        FehlerNr;
    tAufnahmeDaten Data;
    int            GesamtzahlFrames;
    int            AnzahlSamples;
    SAMPLE         Maximum, Durchschnitt, Wert;

    GesamtzahlFrames = DauerInSekunden * SampleRate; // Aufnahmezeit
    Data.MaxFrameIndex = GesamtzahlFrames;
    Data.FrameIndex = 0;
    AnzahlSamples = GesamtzahlFrames * AnzahlKanaele;

    Data.AufnahmeSamples = new SAMPLE[AnzahlSamples];
    for (int i=0; i<AnzahlSamples; i++) {
        Data.AufnahmeSamples[i] = 0;
    }

    pruefeFehler(Pa_Initialize());
    // Aufnahme starten...
    FehlerNr = Pa_OpenDefaultStream(
            &Stream,
            2,          // input Kanaele
            0,          // output Kanaele
            PA_SAMPLE_TYPE,
            SampleRate,
            FramePufferRate,
            recordCallback,
            &Data);
    pruefeFehler(FehlerNr);

    pruefeFehler(Pa_StartStream(Stream));
    cout << "Aufnahme startet!" << endl;

    while (Pa_IsStreamActive(Stream)) {
        Pa_Sleep(1000);
        cout << "index = " << Data.FrameIndex << endl;
    }

    pruefeFehler(Pa_CloseStream(Stream));

    // Statistik berechnen
    Maximum = 0;
    Durchschnitt = 0;
    for (int i=0; i<AnzahlSamples; i++) {
        Wert = Data.AufnahmeSamples[i];
        if( Wert < 0 ) Wert = -Wert; // Absolutbetrag
        if( Wert > Maximum ) {
            Maximum = Wert;
        }
        Durchschnitt += Wert;
    }
    Durchschnitt = Durchschnitt / AnzahlSamples;

    cout << "Max. Amplitude = " << Maximum << endl;
    cout << " Durchschnitt = " << Durchschnitt << endl;

    Sichern(Data, GesamtzahlFrames);

    // Playback
    Data.FrameIndex = 0;
    cout << "Beginn Playback" << endl;
    FehlerNr = Pa_OpenDefaultStream(
            &Stream,
            0,          // Input Kanaele
            2,          // Output Kanaele
            PA_SAMPLE_TYPE,
            SampleRate,
            FramePufferRate,
            playCallback,
            &Data );
    pruefeFehler(FehlerNr);

    if (Stream) {
        pruefeFehler(Pa_StartStream(Stream));
        cout << "Bitte bis zume Ende der Wiedergabe warten!"
             << endl;
        while( Pa_IsStreamActive( Stream ) ) Pa_Sleep(100);

        pruefeFehler(Pa_CloseStream(Stream));
        cout << "Fertig." << endl;
    }
    delete[] Data.AufnahmeSamples;

    Pa_Terminate();
    return 0;
}

