// Labyrinthgenerator
// Arnold Willemer
// Galileo-Computing

#include "labyrinth.h"

#include <iostream>
using namespace std;
#include <stdlib.h>
#include <ctime>



// Das Programm erhaelt als Parameter die Dimension des Labyrinths.
int main(int argc, char* argv[])
{
    cout << "Verwendung: ";
    cout << argv[0] << " [<breite> [<hoehe> [<startwert>]]" << endl;
    int Breite = 40;
    int Hoehe  = 40;

    if (argc>=2) {
        Breite = atoi(argv[1]);
        if (Breite < 3) return 1;
    }

    if (argc>=3) {
        Hoehe = atoi(argv[2]);
        if (Hoehe < 3) return 2;
    }

    tLabyrinth Labyrinth(Breite, Hoehe);

    // Durch Angabe einer Nummer kann immer wieder das gleiche
    // Labyrinth erzeugt werden.
    int ZufallsStartwert=0;
    if (argc>=4) {
        ZufallsStartwert = atoi(argv[3]);
    }

    // Wenn der Aufrufer nichts Anderes angibt, nehmen wir die 
    // aktuelle Uhrzeit als Startwert.
    if (ZufallsStartwert == 0) {
        ZufallsStartwert = time(0);
    }
    srand(ZufallsStartwert);

    // wir brauchen eine zufaellige Startkoordinate
    int x = rand() % Breite;
    int y = rand() % Hoehe;
    // ... und erzeugen ein Labyrinth
    Labyrinth.generiere(x, y);
    Labyrinth.durchbrecheTrennung(1, -1, 1, 0);
    // Unser Stolz gehoert auf den Bildschirm
    Labyrinth.zeige();
}

