// Labyrinthgenerator
// Arnold Willemer
// Galileo-Computing

#include "labyrinth.h"

#include <stdlib.h>
#include <ctime>

#include <iostream>
using namespace std;

class t3DLabyrinth : public tLabyrinth {
public:
    t3DLabyrinth(int x, int y);
    void zeigeNord(int x, int y);
    void zeigeSued(int x, int y);
    void zeigeWest(int x, int y);
    void zeigeOst(int x, int y);
    void zeigeRichtung(int xPos, int yPos, int xDiff, int yDiff);
};


t3DLabyrinth::t3DLabyrinth(int Breite, int Hoehe)
                          : tLabyrinth(Breite, Hoehe)
{
}


const int MAXPANEL=32;

class tPanel {
public:
    tPanel();
    void zeichneWand(int xPos, int yTiefe);
    void zeichneLWand(int Tiefe);
    void zeichneRWand(int Tiefe);
    void zeige();
    void clear();
private:
    char Feld[MAXPANEL][MAXPANEL];
};

tPanel::tPanel()
{
    clear();
}

void tPanel::clear()
{
    for (int i=0; i<MAXPANEL; i++) {
        for (int j=0; j<MAXPANEL; j++) {
             Feld[i][j] = '.';
        }
    }
}

void tPanel::zeige()
{
    for (int y=0; y<MAXPANEL; y++) {
        for (int x=0; x<MAXPANEL; x++) {
            cout << Feld[x][y];
        }
        cout << endl;
    }
    cout << endl;
}

const int DIST = 2;

// pos geht von -1 (links), 0 (mitte), 1 (rechts)
// Tiefe gibt die Entfernung in Zellen an
void tPanel::zeichneWand(int Tiefe, int pos)
{
    // Auch eine Wand der Tiefe 0 ist einen Schritt vor uns
    // Sonst koennten wir sie nicht sehen!
    Tiefe++;
    // Die Kantenlaenge ergibt sich aus der Perspektive
    int Kante = MAXPANEL-2*DIST*Tiefe;
    int yStart = (MAXPANEL-Kante)/2;
    int xStart = pos*(Kante) + yStart;
    int yEnde = yStart + Kante - 1;
    int xEnde = xStart + Kante - 1;
    if (xStart<0) xStart=0;
    if (xEnde>=MAXPANEL) xEnde=MAXPANEL;
    // die folgenden Grenzen sollten eigentlich nur bei einem
    // Programmfehler ueberschritten werden.
    if (yStart<0) yStart=0;
    if (yEnde>=MAXPANEL) yEnde=MAXPANEL-1;
    for (int xi=xStart; xi<xEnde; xi++)  {
        for (int yi=yStart; yi<yEnde; yi++)  {
            Feld[xi][yi] = 'X';
        }
        Feld[xi][yStart] = '-';
        Feld[xi][yEnde] = '-';
    }
    for (int yi=yStart; yi<yEnde; yi++)  {
        if (xStart!=0) Feld[xStart][yi] = '|';
        if (xEnde!=MAXPANEL-1) Feld[xEnde][yi] = '|';
    }
    if (xStart!=0) {
        Feld[xStart][yStart] = '+';
        Feld[xStart][yEnde] = '+';
    }
    if (xEnde!=MAXPANEL-1) {
        Feld[xEnde][yStart] = '+';
        Feld[xEnde][yEnde] = '+';
    }
}

void tPanel::zeichneLWand(int Tiefe)
{
    for (int y=DIST*Tiefe+1; y<MAXPANEL-DIST*Tiefe-1; y++) {
        Feld[DIST*Tiefe][y] = '|';
        Feld[DIST*Tiefe+1][y] = '|';
    }
    Feld[DIST*Tiefe][DIST*Tiefe] = '\\';
    Feld[DIST*Tiefe+1][DIST*Tiefe+1] = '\\';
    Feld[DIST*Tiefe][MAXPANEL-DIST*Tiefe-1] = '/';
    Feld[DIST*Tiefe+1][MAXPANEL-DIST*Tiefe-2] = '/';
//cout <<"("<<Tiefe<<")"<<" x="<<DIST*Tiefe<<","<<MAXPANEL-DIST*Tiefe<<endl;
}

void tPanel::zeichneRWand(int Tiefe)
{
    for (int y=DIST*Tiefe+1; y<MAXPANEL-DIST*Tiefe-1; y++) {
        Feld[MAXPANEL-DIST*Tiefe-2][y] = '|';
        Feld[MAXPANEL-DIST*Tiefe-1][y] = '|';
    }
    Feld[MAXPANEL-DIST*Tiefe-2][DIST*Tiefe+1] = '/';
    Feld[MAXPANEL-DIST*Tiefe-1][DIST*Tiefe] = '/';
    Feld[MAXPANEL-DIST*Tiefe-2][MAXPANEL-DIST*Tiefe-2] = '\\';
    Feld[MAXPANEL-DIST*Tiefe-1][MAXPANEL-DIST*Tiefe-1] = '\\';
}


tPanel Panel;


void t3DLabyrinth::zeigeNord(int xPos, int yPos)
{
    Panel.clear();
    cout << "Nord "<<xPos<<","<<yPos<<endl;
    int MaxEbene = Hoehe-yPos-1;
    for (int Ebene=MaxEbene; Ebene>=0; Ebene--) {
        // Die Wand vor uns
        // Es wird die Achse links, mitte und rechts betrachtet.
        // Sie koennen evtl durch die Luecken gesehen werden.
        for (int xKorr=xPos-1; xKorr<=xPos+1; xKorr++) {
            if (istTrennung(xKorr, Ebene+yPos+1, xKorr, Ebene+yPos)) {
                Panel.zeichneWand(Ebene, xKorr-xPos);
            }
        }
        // Wand links in Laufrichtung
        if (istTrennung(xPos, Ebene+yPos, xPos-1, Ebene+yPos)) {
            Panel.zeichneLWand(Ebene);
        }
        // Wand rechts in Laufrichtung
        if (istTrennung(xPos, Ebene+yPos, xPos+1, Ebene+yPos)) {
            Panel.zeichneRWand(Ebene);
        }
    } 
    Panel.zeige();
}

// Die Funktion Sued gibt in vielen Fällen unsinnige Darstellungen.
void t3DLabyrinth::zeigeSued(int xPos, int yPos)
{
    Panel.clear();
    cout << "Sued "<<xPos<<","<<yPos<<endl;
    int MaxEbene = yPos;

    for (int Ebene=MaxEbene; Ebene>=0; Ebene--) {
        // Die Wand vor uns
        // Es wird die Achse links, mitte und rechts betrachtet.
        // Sie koennen evtl durch die Luecken gesehen werden.
        for (int xKorr=xPos+1; xKorr>=xPos-1; xKorr--) {
            if (istTrennung(xKorr, yPos-Ebene-1, xKorr, yPos-Ebene)) {
                Panel.zeichneWand(Ebene, -(xKorr-xPos));
            }
        }
        // Wand links
        if (istTrennung(xPos, yPos-Ebene, xPos+1, yPos-Ebene)) {
            Panel.zeichneLWand(Ebene);
        }
        // Wand rechts senkrecht
        if (istTrennung(xPos, yPos-Ebene, xPos-1, yPos-Ebene)) {
            Panel.zeichneRWand(Ebene);
        }
    } 
    Panel.zeige();
}

// klappt noch nicht ganz, wenn man an der linken Wand ist. Dann sieht man
// plötzlich nichts mehr!
void t3DLabyrinth::zeigeWest(int xPos, int yPos)
{
    Panel.clear();
    cout << "West "<<xPos<<","<<yPos<<endl;
    int MaxEbene = xPos;

    for (int Ebene=MaxEbene; Ebene>=0; Ebene--) {
        // Die Wand vor uns
        // Es wird die Achse links, mitte und rechts betrachtet.
        // Sie koennen evtl durch die Luecken gesehen werden.
        for (int yKorr=yPos-1; yKorr<=yPos+1; yKorr++) {
            if (istTrennung(xPos-Ebene-1, yKorr, xPos-Ebene, yKorr)) {
                Panel.zeichneWand(Ebene, yKorr-yPos);
            }
        }
        // Wand links
        if (istTrennung(xPos-Ebene, yPos, xPos-Ebene, yPos-1)) {
            Panel.zeichneLWand(Ebene);
        }
        // Wand rechts senkrecht
        if (istTrennung(xPos-Ebene, yPos, xPos-Ebene, yPos+1)) {
            Panel.zeichneRWand(Ebene);
        }
    } 
    Panel.zeige();
}

void t3DLabyrinth::zeigeOst(int xPos, int yPos)
{
    Panel.clear();
    cout << "Ost "<<xPos<<","<<yPos<<endl;
    int MaxEbene = Breite-xPos-1;

    for (int Ebene=MaxEbene; Ebene>=0; Ebene--) {
        // Die Wand vor uns
        // Es wird die Achse links, mitte und rechts betrachtet.
        // Sie koennen evtl durch die Luecken gesehen werden.
        for (int yKorr=yPos+1; yKorr>=yPos-1; yKorr--) {
            if (istTrennung(xPos+Ebene, yKorr, xPos+Ebene+1, yKorr)) {
                Panel.zeichneWand(Ebene, -(yKorr-yPos));
            }
        }
        // Wand links
        if (istTrennung(xPos+Ebene, yPos, xPos+Ebene, yPos+1)) {
            Panel.zeichneLWand(Ebene);
        }
        // Wand rechts senkrecht
        if (istTrennung(xPos+Ebene, yPos, xPos+Ebene, yPos-1)) {
            Panel.zeichneRWand(Ebene);
        }
    } 
    Panel.zeige();
}

// zeigt von der Position xPos,yPos in die Richtung, die durch
// xDiff,yDiff vorgegeben wird. 0,-1 nord, 0,1 sued, -1,0 west, 1,0 ost
void t3DLabyrinth::zeigeRichtung(int xPos, int yPos, int xDiff, int yDiff)
{
    Panel.clear();
    // int MaxEbene = xDiff*(Breite-xPos) + yDiff*(Hoehe-yPos);
    int MaxEbene;
    if (xDiff==-1) MaxEbene = xPos;
    if (xDiff==1) MaxEbene = Breite-xPos;
    if (yDiff==1) MaxEbene = Hoehe-yPos;
    if (yDiff==-1) MaxEbene = yPos;
cout <<" xPos: "<<xPos<<" yPos: "<<yPos<<" xDiff: "<<xDiff<<" yDiff: "<<yDiff
     <<" MaxEbene: "<<MaxEbene<<endl;
    // wir naehern uns in der Ebene von weit nach nah
    for (int Ebene=MaxEbene; Ebene>0; Ebene--) {
        // Die Wand vor uns
        // Es wird die Achse links, mitte und rechts betrachtet.
        // Sie koennen evtl durch die Luecken gesehen werden.
        //
        // Der Korridor wird aus der Diff gebildet und läuft
        // entweder von -1 bis 1 oder bleibt 0.
        // Das gewaehrleisten die for-Schleifen.
        for(int xKorr=(-1)*yDiff;
            xKorr*xKorr <= 1; // 0 oder +1!
            xKorr=yDiff?xKorr+yDiff:2) {
            // Das Gleiche noch fuer y:
            for(int yKorr=xDiff;
                yKorr*yKorr <= 1;
                yKorr=xDiff?yKorr-xDiff:2) {
                // Ist eine Wand frontal vor uns?
                if (istTrennung(xPos+xKorr+xDiff*xDiff+xDiff*xDiff*Ebene,
                                yPos+yKorr+yDiff*yDiff+yDiff*yDiff*Ebene,
                                xPos+xKorr+      xDiff*xDiff*Ebene,
                                yPos+yKorr+      yDiff*yDiff*Ebene)) {
                    Panel.zeichneWand(Ebene, xKorr+yKorr);
                }
            }
        }
        // Wand links
        if (istTrennung(xPos      +xDiff*xDiff*Ebene,
                        yPos      +yDiff*yDiff*Ebene,
                        xPos-yDiff+xDiff*xDiff*Ebene,
                        yPos+xDiff+yDiff*yDiff*Ebene)) {
            Panel.zeichneLWand(Ebene);
        }
        // Wand rechts senkrecht
        if (istTrennung(xPos      +xDiff*xDiff*Ebene,
                        yPos      +yDiff*yDiff* Ebene,
                        xPos+yDiff+xDiff*xDiff*Ebene,
                        yPos-xDiff+yDiff*yDiff*Ebene)) {
            Panel.zeichneRWand(Ebene);
        }
    } 
    Panel.zeige();
}


// Das Programm erhaelt als Parameter die Dimension des Labyrinths.
int main(int argc, char* argv[])
{
    cout << "Verwendung: ";
    cout << argv[0] << " [<breite> [<hoehe> [<startwert>]]" << endl;
    int Breite = 12;
    int Hoehe  = 12;

    if (argc>=2) {
        Breite = atoi(argv[1]);
        if (Breite < 3) return 1;
    }

    if (argc>=3) {
        Hoehe = atoi(argv[2]);
        if (Hoehe < 3) return 2;
    }

    t3DLabyrinth Labyrinth(Breite, Hoehe);

    // Durch Angabe einer Nummer kann immer wieder das gleiche
    // Labyrinth erzeugt werden.
    int ZufallsStartwert=0;
    if (argc>=4) {
        ZufallsStartwert = atoi(argv[3]);
    }

    // Wenn der Aufrufer nichts Anderes angibt, nehmen wir die 
    // aktuelle Uhrzeit als Startwert.
    if (ZufallsStartwert == 0) {
        ZufallsStartwert = time(0);
    }
    srand(ZufallsStartwert);

    // wir brauchen eine zufaellige Startkoordinate
    int x = rand() % Breite;
    int y = rand() % Hoehe;
    // ... und erzeugen ein Labyrinth
    Labyrinth.generiere(x, y);
    // Bastele ein paar Ausgaenge: Unten, oben rechts, links
    Labyrinth.bauAusgangSued(1);
    Labyrinth.bauAusgangNord(7);
    Labyrinth.bauAusgangOst(4);
    Labyrinth.bauAusgangWest(6);
    // Unser Stolz gehoert auf den Bildschirm
    Labyrinth.zeige();
    // Labyrinth.zeigeNord(Breite/2, 0);
    cout << "Gebe Taste und Return ein: L-links, R-rechts, G-gehen" << endl;
    char Kommando=' ';
    int Richtung[4][2] = { {0, 1}, {1, 0}, {0, -1}, {-1, 0} };
    int Laufrichtung = 0;
    int xDiff = 0;
    int yDiff = 1; // Norden1
    int xPos = Breite/2;
    int yPos=0;
    // xPos=0; yPos=6;yDiff=-1; Laufrichtung = 2;
    xPos=4; yPos=10;xDiff=1;yDiff=0; Laufrichtung = 1;
    while (Kommando!='q' && Kommando!='Q') {
        // Labyrinth.zeigeRichtung(xPos, yPos , xDiff, yDiff);
        if (xDiff==-1) Labyrinth.zeigeWest(xPos, yPos);
        if (xDiff==1) Labyrinth.zeigeOst(xPos, yPos);
        if (yDiff==-1) Labyrinth.zeigeSued(xPos, yPos);
        if (yDiff==1) Labyrinth.zeigeNord(xPos, yPos);
        cin >> Kommando;
        switch (Kommando) {
        case 'L': case 'l':
            Laufrichtung--; if (Laufrichtung<0) Laufrichtung=3;
            xDiff=Richtung[Laufrichtung][0];
            yDiff=Richtung[Laufrichtung][1];
            break;
        case 'R': case 'r':
            Laufrichtung++; if (Laufrichtung>3) Laufrichtung=0;
            xDiff=Richtung[Laufrichtung][0];
            yDiff=Richtung[Laufrichtung][1];
            break;
        case 'G': case 'g':
            if (Labyrinth.istTrennung(xPos, yPos, xPos+xDiff, yPos+yDiff)) {
                cout << "Booiiing!!!!" << endl;
            } else {
                xPos +=xDiff;
                yPos +=yDiff;
                if (xPos<0 || xPos>=Breite
                || yPos<0 || yPos>=Hoehe) {
                    // Ausgang gefunden!
                    cout << "Hurra! Ausgang gefunden!" << endl;
                    Kommando = 'Q';
                }
            }
            break;
        }
    }

}

