#include <stdlib.h>
#include <math.h>
#include <iostream>
#include <sstream>
using namespace std;

// die Beschleunigung durch die Erdanziehungskraft
const double g = 9.81; 

// Die Flugkurve des Objekts, liefert f(x).
double Hoehe(double x, double alpha, double v)
{
    const double Koerpergroesse = 1.7;
    double alphaBogen = alpha/180*3.1415926535;
    return Koerpergroesse + tan(alphaBogen)*x-(g*x*x/
               (2*v*v*cos(alphaBogen)*cos(alphaBogen)));
}

// Die x-Position des Scheitels
double MaxHoehe(double alpha, double v)
{
    double alphaBogen = alpha/180*3.1415926535;
	return sin(alphaBogen)*cos(alphaBogen)*v*v/g;
}

// tErfolg ist die Aufzaehlung der Ergebnisse
enum tErfolg { Treffer, Decke, AmSchrank, AufSchrank, 
               BodenVorSchrank, BodenVorNapf, 
		       BodenHinterNapf, Rueckwand };

// Bildschirmausgabe
void zeigeErfolg(tErfolg e)
{
    switch(e) {
    case Treffer:
	    cout << "Treffer" << endl;
		break;
    case Decke:
	    cout << "An der Decke" << endl;
		break;
    case AmSchrank:
	    cout << "am Schrank" << endl;
		break;
    case AufSchrank:
	    cout << "auf dem Schrank" << endl;
		break;
    case BodenVorSchrank:
	    cout << "Boden vor dem Schrank" << endl;
		break;
    case BodenVorNapf:
	    cout << "Boden vor dem Napf" << endl;
		break;
    case BodenHinterNapf:
	    cout << "Boden hinter dem Napf" << endl;
		break;
    case Rueckwand:
	    cout << "an der Rueckwand" << endl;
		break;
	default:
	    cout << "was ist das?" << endl;
    }
}

const double SchrankTiefe = 0.4;

class tRaum {
public:
    tRaum() {}
	void erzeuge();
    tErfolg spuck(double winkel, double v);
private:
   double Raumlaenge;
   double Deckenhoehe;
   double DistanzSchrank;
   double TiefeSchrank;
   double HoeheSchrank;
   double NapfVorn;
   double NapfHinten;
};

// generiert einem Raum, in dem gespuckt werden kann
void tRaum::erzeuge()
{
    // die Spuckgeschwindigkeit liegt zwischen 4 und 9
    double vSpuck = 4.0 + double(rand() % 50)/10.0;
    // der Winkel
    double alpha = 60 - vSpuck -  double(rand() % 20);

    double y, alt=0.0;
    double yMaxHoehe=0.0;
    double xMaxHoehe = 0.0;
    bool top = false;
    double x=0.0;
    while(true) {
        y = Hoehe(x, alpha, vSpuck);
        // cout << "x: " << x << " y: " << y << endl;
        if (y>yMaxHoehe) {
            yMaxHoehe = y;
            xMaxHoehe = x;
            top = true;
        } else {
            if (top) {
                DistanzSchrank = xMaxHoehe;
		top = false;
            }
        }

        if (alt*y < 0) {
            // gelandet!
            break;
        }
        alt = y;
	x+=.1;
    }
    NapfVorn = x - 0.2;
    NapfHinten = x + 0.2;
    Raumlaenge = x + 2.0;
    Deckenhoehe = yMaxHoehe + 0.5;
    DistanzSchrank -= 0.2;
    HoeheSchrank = Hoehe(DistanzSchrank, alpha, vSpuck);
    int ZweiteHoehe = Hoehe(DistanzSchrank+SchrankTiefe, alpha, vSpuck);
    if (ZweiteHoehe<HoeheSchrank) HoeheSchrank = ZweiteHoehe;
    HoeheSchrank -= 0.3;
}

tErfolg tRaum::spuck(double winkel, double v)
{
    double Scheitel = MaxHoehe(winkel, v);
	double yMax = Hoehe(Scheitel, winkel, v);
	if (Scheitel<DistanzSchrank) {
	    if (yMax>Deckenhoehe) return Decke;
	}
    double y = Hoehe(DistanzSchrank, winkel, v);
	if (y < 0) return BodenVorSchrank;
	if (y < HoeheSchrank) return AmSchrank;
	y = Hoehe(DistanzSchrank+SchrankTiefe, winkel, v);
	if (y < HoeheSchrank) return AufSchrank;
	double yWand = Hoehe(Raumlaenge, winkel, v);
	if (yWand>Deckenhoehe) return Decke;
	y = Hoehe(NapfVorn, winkel, v);
	if (y<0) return BodenVorNapf;
	double yNapf = Hoehe(NapfHinten, winkel, v);
    if (y*yNapf < 0) return Treffer;
	if (yWand<0) return BodenHinterNapf;
	return Rueckwand;
}

// Eingabe in double umwandeln
double str2double(string str)
{
    return atof(str.c_str());
    istringstream inStream(str);
	double out;
    inStream >> out;
    return out;
}

int main()
{
    srand(time(0)); // Zufallszahlen ankurbeln
    tRaum Raum;
	// Hier koennte die Schleife zur Spielwiederholung starten
    Raum.erzeuge();
    double v = 1.0;
    double winkel = 0.0;
	int Versuche=0;
	tErfolg Erfolg = Decke;
    while (Erfolg!=Treffer) {
        string Antwort="";
        cout << "Geschwindigkeit: " << endl;
        getline(cin, Antwort);
        v = str2double(Antwort);
		if (v<=0.0) break;
        Antwort = "";
        cout << "Winkel (1-89): " << endl;
        getline(cin, Antwort);
        winkel = str2double(Antwort);
		if (winkel<1.0 || winkel>89.0) break;
		Erfolg = Raum.spuck(winkel, v);
        zeigeErfolg(Erfolg);
		Versuche++;
    }
	if (Erfolg==Treffer) {
	    cout << "Gewonnen nach "<<Versuche<<" Versuchen.";
		cout << endl;
	}
}

