// Flight Simulator by Jake Jacobs 1980
//
//

#include <stdlib.h>
#include <time.h>

#include <iostream>
#include <iomanip>
using namespace std;

// Die Funktion pdl liefert beim Apple II die Paddle-Werte
int pdl(int what)
{
    // what=0 ist Throttle
    // what=1 ist Hoehenruder
    return 128;
}

enum PenMode { BACKGROUND, FOREGROUND };

void setPen(int color)
{
}

void zeichnePunkt(int x, int y)
{
}

void zeichneLinie(int x1, int y1, int x2, int y2)
{
}

void zeichneBahn(int x1, int y1, int x2, int y2, 
                 int x3, int y3, int x4, int y4,
                 int x5=-1, int y5=-1)
{
    cout << setw(7) << x1 << "," << y1;
    cout << " - "   << x2 << "," << y2;
    cout << " - "   << x3 << "," << y3;
    cout << " - "   << x4 << "," << y4;
    cout << endl;
}



const int MaxY=191;
const int MaxX=279;
int XMittelpunkt=MaxX/2;

const int MinHoehe=5;
const int RollbahnLaenge=4000;


double cz=2;
double c1=0 ;
double c2=0.03 ;
double c3=.7 ;
double c4=.09 ;
double c5=.39;
double c8=30 ;
double c9=.09;
double dc=100;
double d=0.95;
double dd=1-d;
double e=.8;
double ee=1-e;
double f=.8;
double ff=1-f;
double h1=.3;

double p5=.055;

double p7=.065;

double m2=RollbahnLaenge/2;
double  m1=RollbahnLaenge/4;
double  m3=m1+m2;

double vm=60;
double vc=1;
double st=20;
double q1=255;
double q3=3;

double q6=600;
double rc=150;
double c=7000;
double v=100;
double hr=h1*(q1-pdl(0));

long DistanzRollbahnEnde;
long Flughoehe;
long Fluggeschwindigkeit;
long Anstieg;
long Hoehenruder;

void neuesSpiel()
{
     DistanzRollbahnEnde=20000 + rand()%20000;
     Flughoehe=1000 + rand()%1000;
}

void SpielEnde() // Goto 1400
{
    cout << endl;
    if (DistanzRollbahnEnde>RollbahnLaenge) {
        cout << "Mit " << DistanzRollbahnEnde-RollbahnLaenge
             << " Fuss vor der Rollbahn mit " << Fluggeschwindigkeit
             << " mph abgestuerzt.";
    } else {
        DistanzRollbahnEnde=DistanzRollbahnEnde-10*v;
        if (DistanzRollbahnEnde<0) { // goto 1630
            cout << "Absturz " << -DistanzRollbahnEnde 
                 << " Fuss hinter der Landebahn mit "
                 << Fluggeschwindigkeit << " mph"
                 << "Abstieg mit " << -Anstieg  << " Fuss/minute.";
        }

        if (Anstieg<-rc) { 
            cout << "bruchlandung mit " << Fluggeschwindigkeit 
                 << " mph und " << -Anstieg << " Abstieggeschwindigkeit";
        } else {
            cout << "Sie sind mit " << Fluggeschwindigkeit 
                 << " mph gelandet und stehen " << DistanzRollbahnEnde 
                 << " Fuss vor dem Ende der Rollbahn.";
        }
    }
    cout << endl;
}



void steuereFlugzeug()
{
    Hoehenruder = pdl(1); // nimmt einen Wert von 0-255 ein
    int pw = int(Hoehenruder*c5);
    int Throttle = pdl(0);
    v = d*v + dd*(Throttle*c3+c8+c4*Hoehenruder);
    double dalt=e*dalt+ee*(c2*Hoehenruder-v*c1-c9*Throttle+cz);
    Anstieg=dc*dalt;
    Flughoehe=Flughoehe+dalt;
    Fluggeschwindigkeit=v*vc;
    char HoehenTipp='-';
    if (Flughoehe>p7*abs(DistanzRollbahnEnde-RollbahnLaenge)) HoehenTipp='V';
    if (Flughoehe<p5*abs(DistanzRollbahnEnde-RollbahnLaenge)) HoehenTipp='^';

    cout << "Hoehe: " << Flughoehe
         << " Anstieg: " << Anstieg
         << " Geschwindigkeit: " << Fluggeschwindigkeit
         << " Entfernung: "
         // << ((DistanzRollbahnEnde+Flughoehe/q3-RollbahnLaenge)/q6)/10
         << DistanzRollbahnEnde
         << " Hoehenruder: " << pw
         << " Hoehenkorrektur: " << HoehenTipp << endl;
    DistanzRollbahnEnde = DistanzRollbahnEnde -v;
    if (v<vm) dalt=-st;
    hr=f*hr+ff*h1*(q1-Throttle);
}

bool f1, f2, f3;
int r1, r2, r3;

void createfX()
{
        f1=false; f2=false; f3=false;
        r1=Flughoehe/(DistanzRollbahnEnde-m1)*MaxY+hr;
        if (r1>0 && r1<MaxY && DistanzRollbahnEnde>m1) f1=true;
        r2=Flughoehe/(DistanzRollbahnEnde-m2)*MaxY+hr;
        if (r2>0 && r2<MaxY && DistanzRollbahnEnde>m2) f2=true;
        r3=Flughoehe/(DistanzRollbahnEnde-m3)*MaxY+hr;
        if (r3>0 && r3<MaxY && DistanzRollbahnEnde>m3) f3=true;
}


bool oldF1, oldF2, oldF3; 
int oldR1, oldR2, oldR3;

int x1,y1, x2,y2, x3,y3, x4,y4, y5;


int AbweichungVorn, AbweichungHinten, VornLinks, VornRechts,
    HintenRechtsX, HintenLinksX, YVorn, YHinten, xo, yr;


int main(int argc,  char* argv[])
{
    int ZufallsStartwert=0;
    if (argc>1) {
        ZufallsStartwert = atoi(argv[1]);
    }

    // Wenn der Aufrufer nichts Anderes angibt, nehmen wir die
    // aktuelle Uhrzeit als Startwert.
    if (ZufallsStartwert == 0) {
        ZufallsStartwert = time(0);
    }
    srand(ZufallsStartwert);

    neuesSpiel();
    while ( true ) {
cout << '.';
        // 500 REM Einsprungpunkt - Beginn der Hauptschleife?
        if (Flughoehe<MinHoehe) {
            SpielEnde(); // Goto 1400
            break;
        }

        yr=Flughoehe/DistanzRollbahnEnde*MaxY + hr;
        if (yr>MaxY || yr<0) yr=MaxY;
        YVorn=Flughoehe/(DistanzRollbahnEnde-RollbahnLaenge)*MaxY+hr;

        createfX();

        // das vordere Ende der Landebahn ist nicht sichtbar, also ziehe
        // eine Linie an der unteren Kante des Bildschirms
        if (DistanzRollbahnEnde-RollbahnLaenge<Flughoehe) YVorn=MaxY;

        AbweichungVorn=(c/(DistanzRollbahnEnde+Flughoehe/q3-RollbahnLaenge));
        AbweichungHinten= c/(DistanzRollbahnEnde+Flughoehe/q3);
        if (DistanzRollbahnEnde-RollbahnLaenge<Flughoehe) {
            AbweichungVorn=c/(Flughoehe+Flughoehe/q3);
        }
        if (AbweichungHinten<0) AbweichungHinten=XMittelpunkt;
        VornLinks=XMittelpunkt-AbweichungVorn;
        VornRechts=XMittelpunkt+AbweichungVorn;
        HintenRechtsX=XMittelpunkt-AbweichungHinten;
        HintenLinksX=XMittelpunkt+AbweichungHinten;
        if (AbweichungHinten>=XMittelpunkt) {
            cout << "Rollbahn mit " <<  Fluggeschwindigkeit 
                 << " mph in der Hoehe von " << Flughoehe << " ueberflogen";
            break;
        }
        if (AbweichungVorn>XMittelpunkt) {

            YHinten = YVorn - (YVorn-yr)*(AbweichungVorn-XMittelpunkt)
                              /(AbweichungVorn-AbweichungHinten);
            if (YHinten<0) YHinten=0;
            if (YHinten>MaxY) { //  goto 1040
                xo=(MaxY-yr)*(AbweichungVorn-AbweichungHinten)
                   /(YVorn-yr) + AbweichungHinten;
                setPen(BACKGROUND);
                if (oldF1) zeichnePunkt( XMittelpunkt,oldR1);
                if (oldF2) zeichnePunkt( XMittelpunkt,oldR2);
                if (oldF3) zeichnePunkt( XMittelpunkt,oldR3);
    
                zeichneBahn(x1,y1, x2,y2, x3,y3, x4,y4, x1,y1);
                if (y5<MaxY) zeichneLinie(0, y5, MaxX, y5);
                setPen(FOREGROUND);
                if (f1) zeichnePunkt( XMittelpunkt,r1);
                if (f2) zeichnePunkt( XMittelpunkt,r2);
                if (f3) zeichnePunkt( XMittelpunkt,r3);
                // ab hier Abweichung zu 710
                // 1150 hplot XMittelpunkt-xo,MaxY to HintenRechtsX,yr to HintenLinksX,yr to XMittelpunkt+xo,MaxY
                zeichneBahn(XMittelpunkt-xo,MaxY,
                            HintenRechtsX,yr,
                            HintenLinksX,yr,
                            XMittelpunkt+xo,MaxY);

                x1=XMittelpunkt-xo; y1=MaxY; x2=HintenRechtsX; y2=yr; 
                x3=HintenLinksX; y3=yr; x4=c3+xo; y4=MaxY;
            } else {
                // Hier wie ab 710
                setPen(BACKGROUND);
                if (oldF1) zeichnePunkt( XMittelpunkt,oldR1);
                if (oldF2) zeichnePunkt( XMittelpunkt,oldR2);
                if (oldF3) zeichnePunkt( XMittelpunkt,oldR3);

                zeichneBahn(x1,y1, x2,y2, x3,y3, x4,y4, x1,y1);
                if (y5<MaxY) zeichneLinie( 0,y5, MaxX,y5);
                setPen(FOREGROUND);
                if (f1) zeichnePunkt( XMittelpunkt,r1);
                if (f2) zeichnePunkt( XMittelpunkt,r2);
                if (f3) zeichnePunkt( XMittelpunkt,r3);
                // hier aber nicht wie in 800, sondern...
                zeichneBahn(0,YHinten,
                            HintenRechtsX,yr,
                            HintenLinksX,yr,
                            MaxX,YHinten);
                if (YVorn<MaxY) zeichneLinie(0, YVorn, MaxX, YVorn);
                x1=0; y1=YHinten; x2=HintenRechtsX; y2=yr; x3=HintenLinksX; 
                y3=yr; x4=MaxX; y4=YHinten; y5=YVorn;
            }

        } else if (YVorn>MaxY) { // goto 1040
            // 1040 REM Ansprungpunkt per GOTO
            xo=(MaxY-yr)*(AbweichungVorn-AbweichungHinten)/(YVorn-yr)+AbweichungHinten;
                setPen(BACKGROUND);
            if (oldF1) zeichnePunkt( XMittelpunkt,oldR1);
            if (oldF2) zeichnePunkt( XMittelpunkt,oldR2);
            if (oldF3) zeichnePunkt( XMittelpunkt,oldR3);

            zeichneBahn( x1,y1, x2,y2, x3,y3, x4,y4, x1,y1);
            if (y5<MaxY) zeichneLinie(0, y5, MaxX, y5);
            setPen(FOREGROUND);
            if (f1) zeichnePunkt( XMittelpunkt,r1);
            if (f2) zeichnePunkt( XMittelpunkt,r2);
            if (f3) zeichnePunkt( XMittelpunkt,r3);
            // ab hier Abweichung zu 710
            zeichneBahn(XMittelpunkt-xo,MaxY,
                        HintenRechtsX,yr,
                        HintenLinksX,yr,
                        XMittelpunkt+xo,MaxY);
            x1=XMittelpunkt-xo; y1=MaxY; x2=HintenRechtsX; y2=yr; 
            x3=HintenLinksX; y3=yr; x4=c3+xo; y4=MaxY;

        } else {

            setPen(BACKGROUND);
            // Die bisherige Zeichnung wird übermalt
            if (oldF1) zeichnePunkt( XMittelpunkt,oldR1);
            if (oldF2) zeichnePunkt( XMittelpunkt,oldR2);
            if (oldF3) zeichnePunkt( XMittelpunkt,oldR3);
            
            zeichneBahn(x1,y1, x2,y2, x3,y3, x4,y4, x1,y1);
            if (y5<MaxY) zeichneLinie(0, y5, MaxX, y5);
            setPen(FOREGROUND);
            // Die neue Zeichnung wird gesetzt
            if (f1) zeichnePunkt( XMittelpunkt,r1);
            if (f2) zeichnePunkt( XMittelpunkt,r2);
            if (f3) zeichnePunkt(XMittelpunkt,r3);

            zeichneBahn(HintenRechtsX,yr,
                        HintenLinksX,yr,
                        VornRechts,YVorn,
                        VornLinks,YVorn,
                        HintenRechtsX,yr);
            x1=VornLinks; y1=YVorn; x2=HintenRechtsX; y2=yr;
            x3=HintenLinksX; y3=yr; x4=VornRechts; y4=YVorn; y5=MaxY;
    
        }
        oldR1=r1; oldR2=r2; oldR3=r3; oldF1=f1; oldF2=f2; oldF3=f3;

        // 830 gosub 1200
        steuereFlugzeug();
    } // 840 goto 500
} // ende der main()


