#include <iostream> 
#include <vector>
#include <map>
#include <iomanip>
#include <cstdlib>
#include <climits>

using namespace std;

#define unendlich LONG_MAX 

class tKnoten {
public:
    tKnoten();
    int Vorgaenger;
    long Distanz;
    bool Markiert;
}; 

tKnoten::tKnoten()
{
    Vorgaenger = 0;
    Distanz = unendlich;
    Markiert = false;
}

// Knotenpaar ist eine Kombination aus zwei Zahlenwerten.
// Sie wird als Index für die map der Adjazenz benötigt.
// Damit sie als Index verwendbar ist, muss die Klasse den
// Kleiner-Operator definieren.
class tKnotenpaar {
public:
    tKnotenpaar(int a, int b) { ind1 = a; ind2 = b; }
    bool operator<(const tKnotenpaar a) const {
        if (ind1<a.ind1) return true;
        if (ind1==a.ind1 && ind2<a.ind2) return true;
        return false;
    }
private:
    int ind1; int ind2;
};

// Die Adjazenzmatrix speichert den Graphen.
class tAdjazenz {
public:
    static tAdjazenz *getInstance();
    long get(int, int);
    void set(int index1, int index2, long Wert);
    long getMaxKnoten() { return MaxKnoten; }

private:
    tAdjazenz() { MaxKnoten=0; }
    static tAdjazenz *adjazenz;
    map<tKnotenpaar, long> adj;
    long MaxKnoten;
};

tAdjazenz* tAdjazenz::adjazenz = 0;

tAdjazenz* tAdjazenz::getInstance()
{
    if (adjazenz == 0) {
        adjazenz = new tAdjazenz();
    }
    return adjazenz;
}

// Liefere die Gewichtung der Kante zwischen den beiden 
// Knoten
long tAdjazenz::get(int index1, int index2)
{
    tKnotenpaar adr(index1, index2);
    if (adj.find(adr)==adj.end()) {
        return unendlich;
    } else {
        return adj[adr];
    }
}

void tAdjazenz::set(int index1, int index2, long Wert)
{
    if (index1>MaxKnoten) MaxKnoten = index1;
    if (index2>MaxKnoten) MaxKnoten = index2;
    tKnotenpaar adr(index1, index2);
    adj[adr] = Wert;
}

void bauStrassenNetz () 
{
    int i = 1;
	int Herkunft, Ende;
    long Laenge ;
    cout << endl;
    tAdjazenz *adj = tAdjazenz::getInstance();
    while(true) {
        cout << "Gebe Kante " << i
             << " ein (0 0 um die Eingabe zu beenden): ";
        cin >> Herkunft;
        cin >> Ende;
        cout << endl;
        if ((Herkunft == 0) && (Ende == 0)) break;
        cout << "Gebe die Laenge dieser Kante an: ";
        cin >> Laenge;
        if (Herkunft == 0 || Ende == 0) {
            cout << "Ungueltige Kante!" << endl;
        } else {
            adj->set(Herkunft, Ende, Laenge);
            cout << endl << "von " << Herkunft << " nach "
                 << Ende << " Distanz: " << Laenge << endl << endl;
        }
		i++;
    }
}

void zeigeAdjazenzMatrix() 
{
    cout << endl
         << "Die Liste der Verbindungen:" << endl;
    int i, j;
    tAdjazenz *adj = tAdjazenz::getInstance();
    long MaxKnoten = adj->getMaxKnoten();
    for (i=1; i<=MaxKnoten; i++) {
        cout << "Von Knoten " << i << ": ";
        for (j=1; j<=MaxKnoten; j++) {
            long Distanz = adj->get(i, j);
            if (Distanz==unendlich) {
                cout << "-- ";
            } else {
                cout << setfill(' ') << setw (2) << adj->get(i, j) << " ";
            }
        }
        cout << endl;
    }
    cout << endl;
}


int suchePfad (int Aktuell, int Ziel, vector<int> &Pfad,
               long* GesamtDistanz)
{
    map<int, tKnoten> PrioQueue;
    int i;
    tAdjazenz *adj = tAdjazenz::getInstance();
    *GesamtDistanz = 0 ;
    // Startknoten hat keinen Vorgaenger und keine Distanz
    PrioQueue[Aktuell].Markiert = true;
    PrioQueue[Aktuell].Distanz = 0;
    // Solange wir noch nicht angekommen sind...
    while (Aktuell!= Ziel) {
        // In der Adjazenzmatrix wird nach Nachbarn gesucht
        for (i=1; i<=adj->getMaxKnoten(); i++) {
            long NachbarnDistanz = adj->get(Aktuell, i);
            if (NachbarnDistanz != unendlich) {
                // Wurde Knoten noch nicht markiert?
                if (PrioQueue[i].Markiert == false) {
                    // ermittle die Entfernung zzgl der
                    // bisherigen Distanz zum Start
                    long NeueDistanz = PrioQueue[Aktuell].Distanz
                                     + NachbarnDistanz;
                    // Kleiner? Dann ist das die bessere Strecke
                    if (NeueDistanz < PrioQueue[i].Distanz) {
                        PrioQueue[i].Vorgaenger = Aktuell;
                        PrioQueue[i].Distanz = NeueDistanz;
                    }
                }
            }
        } // Nachbarnsuche beendet

        // Aus den unmarkierten der PrioQueue wird der 
        // naechstgelegene Ausgangspunkt ermittelt
        long min = unendlich;
        Aktuell = 0; // ungueltig machen
        // Durch alle Elemente der PrioQueue laufen
        map<int, tKnoten>::iterator it;
        for (it=PrioQueue.begin(); it!=PrioQueue.end(); ++it) {
            i = it->first; // Index ermitteln
            if (PrioQueue[i].Markiert == false
            && PrioQueue[i].Distanz<min) {
                // bisher der naechste von der Startposition
                min = PrioQueue[i].Distanz;
                Aktuell = i;
            }
        }

        // Wenn Quelle oder Ziel isoliert, ist hier Ende
        if (Aktuell == 0) {
            return 0;
        }
        // Ansonsten wird der neue Kandidat markiert
        PrioQueue [Aktuell].Markiert = true;
    } // solange wir nicht am Ziel sind...

    // Ermittle den Pfad vom Ziel zum Startpunkt
    int SchrittZahl = 0;
    while (Aktuell!= 0) {
        SchrittZahl++;
        Pfad.push_back(Aktuell);
        Aktuell = PrioQueue[Aktuell].Vorgaenger;
    } 
    // Ermittle die Distanz von der Quelle bis zum Ziel
    int KantenAnfang, KantenEnde;
    for (i=0; i<SchrittZahl-1; i++) {
        KantenEnde = Pfad[i];
        KantenAnfang = Pfad[i+1];
        *GesamtDistanz += adj->get(KantenAnfang, KantenEnde);
    }
    return SchrittZahl;
}

int main() 
{
    bauStrassenNetz();
    zeigeAdjazenzMatrix(); 
    for (;;) { // forever: bis Benutzer abbricht 
        int Quelle, Ziel;
        cout << endl
             << "Gebe den Startpunkt an (0 = Abbruch):";
        cin>> Quelle;
        if (Quelle == 0) exit (1);
        cout << endl
             << "Gebe den Zielpunkt an (0 = Abbruch):";
        cin>> Ziel;
        if (Ziel == 0) exit (1);

        vector<int> Pfad; // Der kuerzeste Pfad
        long KuerzesteDistanz;
        int SchrittZahl;

        SchrittZahl = suchePfad (Quelle, Ziel, Pfad,
                                 &KuerzesteDistanz);
        if (KuerzesteDistanz != 0) {
            cout << "Die kuerzeste Strecke ist: "
                 << KuerzesteDistanz << endl;
            cout << "Der kuerzeste Pfad ist: ";
            int i;
            for (i=SchrittZahl-1; i>0; i--)
            {
                cout << Pfad[i] << " ";
            }
            cout << Pfad[i] << endl;
        } else {
            cout << "Es gibt keinen Weg vom Start zum Ziel"
                 << endl;
        }
    } // Ende forever Benutzereingabe
} // Ende main()

