#include "feld.h"

#include <iostream>
using namespace std;
#include <stdlib.h>

tFeld::tFeld()
{
	int i, j;
	int x, y;

	srand(time(0));
	i=0;
	while (i<MaxSchiff) 
	{
		x = rand() % MaxX;
		y = rand() % MaxY;
		Schiff[i].setPosition(x,y);
		for (j=0; j<i; j++)
		{
			if (Schiff[j].getX()==x && Schiff[j].getY()==y)
			{
				// Die Schiffe sind gleich, wir brauchen ein
				// Neues!
				i--;
				break;
			}
		}
		i++;
	}
	for(i=0; i<MaxX; i++)
	{
		for (j=0; j<MaxY; j++)
		{
			Wasser[i][j] = '+';
		}
	}
}

tFeld::~tFeld()
{
}


int tFeld::istHierEinSchiff(int px, int py)
{ // ist hier etwas?
	int i;
	
	for (i=0; i<MaxSchiff; i++) 
	{
		if (Schiff[i].getX()==px && Schiff[i].getY()==py) 
		{
			return i+1;
		}
	}
	return 0;
}

int tFeld::pruefeRichtung(int px, int py, int dx, int dy)
{ // laufe eine Linie entlang
	if (dx==0 && dy==0) return 0;
	while (px>=0 && px<MaxX && py>=0 && py<MaxY) 
	{
		if (istHierEinSchiff(px, py)>0) return 1;
        px += dx;
        py += dy;
    }
	return 0;		
}


int tFeld::zaehlePeilungen(int px, int py)
{
	// haben wir bereits ein Schiff getroffen?
	int Anzahl = istHierEinSchiff(px, py);
	if (Anzahl>0) {
		Wasser[px][py] = '*';
		Schiff[Anzahl-1].setGefunden();
		return SCHIFF;
	}

	// suche in alle Richtungen
	for (int dx=-1; dx<=1; dx++) {
		for (int dy=-1; dy<=1; dy++) {
			Anzahl += pruefeRichtung(px, py, dx, dy);
		}
	}

	Wasser[px][py] = (char)('0'+Anzahl);
	return Anzahl;
}

void tFeld::markiere(int x, int y, bool kipp)
{
    char Inhalt = Wasser[x][y];
    if (Inhalt=='+') {
        Wasser[x][y] = '.';
    } else if (kipp && Inhalt=='.') {
        Wasser[x][y] = '+';
    }
}

void tFeld::markiereRichtung(int px, int py, int dx, int dy)
{ // laufe eine Linie entlang
    if (dx==0 && dy==0) return;
    while (px>=0 && px<MaxX && py>=0 && py<MaxY) 
    {
        markiere(px, py, false);
        px += dx;
        py += dy;
    }
}

void tFeld::markiereNull(int px, int py)
{
	// suche in alle Richtungen
    for (int dx=-1; dx<=1; dx++) {
        for (int dy=-1; dy<=1; dy++) {
            markiereRichtung(px, py, dx, dy);
        }
    }
}

void tFeld::zeige()
{
	int i, j;

	cout << "   ";
	for (i=0; i<MaxX; i++)
	{
		cout << (char)('A'+i) <<" " ;
	}
	cout << endl;

	for (j=0; j<MaxY; j++)
	{
		cout << j+1 << "  ";
		for(i=0; i<MaxX; i++)
		{
			cout << Wasser[i][j] << " ";
		}
		cout << endl;
	}
}

bool tFeld::istGewonnen()
{
	bool gewonnen = true;

	for (int i=0; i<MaxSchiff; i++) 
	{
		if (!Schiff[i].istGefunden())
		{
			gewonnen = false;
		}
	}
	return gewonnen;
}
