#include <wx/wx.h>
#include <wx/imaggif.h>

#include "avalanche.h"

const int Distanz = 120;
const int Offset  = 1;
const int KugelRadius = 20;

class wxavalancheapp : public wxApp {
    public:
        virtual bool OnInit();
};

class wxavalancheFrame : public wxFrame {
    public:
        wxavalancheFrame(const wxString& title, 
                         const wxPoint& pos, 
                         const wxSize& size);
        void OnMouseEvent(wxMouseEvent& event);
        void OnPaint(wxPaintEvent& event);

    private:
        wxImage imgHebelLinks, imgHebelRechts;
        DECLARE_EVENT_TABLE()
};

BEGIN_EVENT_TABLE( wxavalancheFrame, wxFrame )
	EVT_MOUSE_EVENTS(wxavalancheFrame::OnMouseEvent)
    EVT_PAINT(wxavalancheFrame::OnPaint)
END_EVENT_TABLE()

IMPLEMENT_APP(wxavalancheapp)

bool wxavalancheapp::OnInit()
{
	wxavalancheFrame *frame = new wxavalancheFrame(
            wxT("Avalanche"), wxPoint(50,50), 
            wxSize(Distanz*(MaxX/2+2), Distanz*(MaxY+2)));

	frame->Show(TRUE);
	SetTopWindow(frame);
	return TRUE;
} 

#define PATH "../../images/"

tFeld *Feld = 0;

wxavalancheFrame::wxavalancheFrame( const wxString& title, const wxPoint& pos, const wxSize& size )
	: wxFrame((wxFrame *)NULL, -1, title, pos, size)
{
    wxImageHandler *GifHandler = new wxGIFHandler();
    wxImage::AddHandler(GifHandler);

    imgHebelLinks.LoadFile(wxT(PATH "hebellinks.gif"), wxBITMAP_TYPE_GIF);
    imgHebelRechts.LoadFile(wxT(PATH "hebelrechts.gif"), wxBITMAP_TYPE_GIF);
    Feld = new tFeld();
}


void wxavalancheFrame::OnMouseEvent(wxMouseEvent& event)
{
    wxClientDC dc(this);
    wxPoint pt(event.GetLogicalPosition(dc));
    int x = 2*(pt.x - Distanz/4)/Distanz - Offset;
    if (x<1 || x>MaxX-1) return;
    if (event.LeftDown()) {
        Feld->Wurf(x, 0, Weiss);
        Refresh();
    }
}

void wxavalancheFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    for (int xi=1; xi<MaxX-1; xi++) {
        dc.DrawCircle(Distanz*(xi)/2+Distanz*Offset, 
                      Distanz/2, KugelRadius);
    }
    for (int yi=0; yi<MaxY/2; yi++) {
        for (int xi=0; xi<MaxX/2; xi++) {
            tHebel *Hebel = Feld->getHebel(xi*2, yi*2);
            int GrafX = Distanz*(xi+Offset);
            int GrafY = Distanz*(yi*2+Offset);
            dc.SetPen(wxPen(*wxGREEN, 4));
            dc.DrawLine(GrafX-KugelRadius, GrafY, 
                        GrafX-KugelRadius, GrafY+Distanz);
            dc.SetPen(wxPen(*wxBLACK, 1));
            if (Hebel->stehtLinks()) {
                dc.DrawBitmap(imgHebelLinks, GrafX, GrafY,
                              true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX, GrafY, KugelRadius);
                }
            } else {
                dc.DrawBitmap(imgHebelRechts,
                              GrafX, GrafY, true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX+Distanz/2, GrafY, 
                                  KugelRadius);
                }
            }
        }

        for (int xi=1; xi<MaxX/2; xi++) {
            tHebel *Hebel = Feld->getHebel(xi*2-1, yi*2+1);
            int GrafX = Distanz*(xi+Offset)-Distanz/2;
            int GrafY = Distanz*(yi*2+1+Offset);
            dc.SetPen(wxPen(*wxGREEN, 4));
            dc.DrawLine(GrafX-KugelRadius, GrafY, 
                        GrafX-KugelRadius, GrafY+Distanz);
            dc.SetPen(wxPen(*wxBLACK, 1));
            if (Hebel->stehtLinks()) {
                dc.DrawBitmap(imgHebelLinks, GrafX, GrafY, true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX, GrafY, KugelRadius);
                }

            } else {
                dc.DrawBitmap(imgHebelRechts, GrafX, GrafY, true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX+Distanz/2, GrafY, 
                                  KugelRadius);
                }
            }
        }
        // In der zweiten und vierten Reihe muss noch 
        // rechts eine Abschlusslinie hinkommen
        dc.SetPen(wxPen(*wxGREEN, 4));
        dc.DrawLine(Distanz*(MaxX/2+Offset)-Distanz/2-KugelRadius,
                    Distanz*(yi*2+1+Offset),
                    Distanz*(MaxX/2+Offset)-Distanz/2-KugelRadius,
                    Distanz*(yi*2+2+Offset));
        dc.SetPen(wxPen(*wxBLACK, 1));
    }
    // Zwei Linien als Umrandung
    dc.SetPen(wxPen(*wxGREEN, 4));
    dc.DrawLine(Distanz*(Offset)-KugelRadius, Distanz*(Offset),
                Distanz*(Offset)-KugelRadius, Distanz*(MaxY+Offset));
    dc.DrawLine(Distanz*(MaxX/2+Offset)-KugelRadius, Distanz*(Offset),
                Distanz*(MaxX/2+Offset)-KugelRadius, Distanz*(MaxY+Offset));
    dc.SetPen(wxPen(*wxBLACK, 1));
}
