#include <deque>
#include <iostream>
using namespace std;

#include "avalanche.h"

class tPosten {
public:
    int x, y;
    tKugel Kugel;
};

deque<tPosten> Fifo;

void Einwurf (int Spalte, int Reihe, tKugel Kugel)
{
	tPosten pos;
	pos.x = Spalte;
	pos.y = Reihe;
	pos.Kugel = Kugel;
	Fifo.push_back(pos);
	cout << "Einwurf: " << pos.x << ", " << pos.y << endl;
}

tHebel::tHebel ( int pLinks, int pRechts )
{
	Links = pLinks;
	Rechts = pRechts;
	Belegung = Keine;
	StoppSpalte = Rechts;
}

void tHebel::Wurf(int Spalte, int Reihe, tKugel Kugel)
{
	if ( Spalte==StoppSpalte ) {
		if ( Belegung==Keine ) {
			Belegung = Kugel;
			return;
		}
	}
	if ( Belegung!=Keine ) {
		// Für die erste Kugel
		int ErsteSpalte = StoppSpalte;
        // Die erste Kugen faellt entgegen der StoppSpalte
		if ( StoppSpalte==Links ) {
			ErsteSpalte = Rechts;
		} else {
			ErsteSpalte = Links;
		}
		// Die eingeworfene Kugel kommt raus,
		Einwurf(ErsteSpalte, Reihe+1, Kugel);
		// lass die belegte Kugel frei
		Einwurf(StoppSpalte, Reihe+1, Belegung);
        // StoppSpalte bleibt, weil sie gleich zurueckgeht
        Belegung = Keine; // wird
        return; // danach darf nichts mehr passieren
	}
    if ( StoppSpalte==Links ) {
		StoppSpalte = Rechts;
	} else {
		StoppSpalte = Links;
	}
	Einwurf ( Spalte, Reihe+1, Kugel );
}

tFeld::tFeld()
{
	for ( int xi=0; xi<MaxX; xi++ ) {
		for ( int yi=0; yi<MaxY; yi++ ) {
			Pos[xi][yi] = 0;
		}
	}

	for ( int yi=0; yi<MaxY/2; yi++ ) {
		for ( int xi=0; xi<MaxX/2; xi++ ) {
			tHebel *NeuHebel = new tHebel ( xi*2, xi*2+1 );
			Pos[xi*2][yi*2] = NeuHebel;
			Pos[xi*2+1][yi*2] = NeuHebel;
		}
		for ( int xi=1; xi<MaxX/2; xi++ ) {
			tHebel *NeuHebel = new tHebel ( xi*2-1, xi*2 );
			Pos[xi*2-1][yi*2+1] = NeuHebel;
			Pos[xi*2][yi*2+1] = NeuHebel;
		}
	}
}

tFeld::~tFeld()
{
    for ( int yi=0; yi<MaxY/2; yi++ ) {
        for ( int xi=0; xi<MaxX/2; xi++ ) {
            delete Pos[xi*2][yi*2];
        }
        for ( int xi=1; xi<MaxX/2; xi++ ) {
            delete Pos[xi*2][yi*2+1];
        }
    }
}

void tFeld::Wurf(int x, int y, tKugel Kugel)
{
	if ( Pos[x][y]==0 ) {
		y++;
        if (y>=MaxY) {
            cout << "raus: " << x << "Farbe: " << Kugel << endl;
        } else {
            Wurf(x, y, Kugel);
        }
	} else {
		Pos[x][y]->Wurf(x, y, Kugel);
	}
	// Nun die FIFO abarbeiten
	while ( Fifo.size() ) {
		tPosten pos = Fifo.front();
		Fifo.pop_front();
		if ( pos.y<MaxY ) {
			Wurf(pos.x, pos.y, pos.Kugel);
		} else {
            cout << "raus: " << x << "Farbe: " << Kugel << endl;
        }
	}
}

