#include <wx/wx.h>

#include "wxKreisClickFrame.h"


BEGIN_EVENT_TABLE( wxKreisClickFrame, wxFrame )
    EVT_MOUSE_EVENTS(wxKreisClickFrame::OnMouseEvent)
    EVT_PAINT(wxKreisClickFrame::OnPaint)
END_EVENT_TABLE()


wxKreisClickFrame::wxKreisClickFrame( const wxString& title, const wxPoint& pos, const wxSize& size )
    : wxFrame((wxFrame *)NULL, -1, title, pos, size)
{
    wxImageHandler *GifHandler = new wxGIFHandler();
    wxImage::AddHandler(GifHandler);

//    imgHebelLinks.LoadFile(wxT(PATH "hebellinks.gif"), wxBITMAP_TYPE_GIF);
//    imgHebelRechts.LoadFile(wxT(PATH "hebelrechts.gif"), wxBITMAP_TYPE_GIF);
}


wxPoint glob;
bool clicked = false;

#include <iostream>

void wxKreisClickFrame::OnMouseEvent(wxMouseEvent& event)
{
    wxClientDC dc(this);
    if (event.LeftDown()) {
        wxPoint pt(event.GetLogicalPosition(dc));
        glob = pt;
        clicked = true;
        Refresh();
        std::cout << pt.x << "," << pt.y << std::endl;
    }
/*
    int x = 2*(pt.x - Distanz/4)/Distanz - Offset;
    if (x<1 || x>MaxX-1) return;
    if (event.LeftDown()) {
        Feld->Wurf(x, 0, Weiss);
        Refresh();
    }
*/
}

void wxKreisClickFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    if (clicked)
        dc.DrawCircle(glob, 5);
    std::cout << ".";
/*
    for (int xi=1; xi<MaxX-1; xi++) {
        dc.DrawCircle(Distanz*(xi)/2+Distanz*Offset, 
                      Distanz/2, KugelRadius);
    }
    for (int yi=0; yi<MaxY/2; yi++) {
        for (int xi=0; xi<MaxX/2; xi++) {
            tHebel *Hebel = Feld->getHebel(xi*2, yi*2);
            int GrafX = Distanz*(xi+Offset);
            int GrafY = Distanz*(yi*2+Offset);
            dc.SetPen(wxPen(*wxGREEN, 4));
            dc.DrawLine(GrafX-KugelRadius, GrafY, 
                        GrafX-KugelRadius, GrafY+Distanz);
            dc.SetPen(wxPen(*wxBLACK, 1));
            if (Hebel->stehtLinks()) {
                dc.DrawBitmap(imgHebelLinks, GrafX, GrafY,
                              true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX, GrafY, KugelRadius);
                }
            } else {
                dc.DrawBitmap(imgHebelRechts,
                              GrafX, GrafY, true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX+Distanz/2, GrafY, 
                                  KugelRadius);
                }
            }
        }

        for (int xi=1; xi<MaxX/2; xi++) {
            tHebel *Hebel = Feld->getHebel(xi*2-1, yi*2+1);
            int GrafX = Distanz*(xi+Offset)-Distanz/2;
            int GrafY = Distanz*(yi*2+1+Offset);
            dc.SetPen(wxPen(*wxGREEN, 4));
            dc.DrawLine(GrafX-KugelRadius, GrafY, 
                        GrafX-KugelRadius, GrafY+Distanz);
            dc.SetPen(wxPen(*wxBLACK, 1));
            if (Hebel->stehtLinks()) {
                dc.DrawBitmap(imgHebelLinks, GrafX, GrafY, true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX, GrafY, KugelRadius);
                }

            } else {
                dc.DrawBitmap(imgHebelRechts, GrafX, GrafY, true);
                tKugel Kugel = Hebel->getBelegung();
                if (Kugel!=Keine) {
                    dc.DrawCircle(GrafX+Distanz/2, GrafY, 
                                  KugelRadius);
                }
            }
        }
        // In der zweiten und vierten Reihe muss noch 
        // rechts eine Abschlusslinie hinkommen
        dc.SetPen(wxPen(*wxGREEN, 4));
        dc.DrawLine(Distanz*(MaxX/2+Offset)-Distanz/2-KugelRadius,
                    Distanz*(yi*2+1+Offset),
                    Distanz*(MaxX/2+Offset)-Distanz/2-KugelRadius,
                    Distanz*(yi*2+2+Offset));
        dc.SetPen(wxPen(*wxBLACK, 1));
    }
    // Zwei Linien als Umrandung
    dc.SetPen(wxPen(*wxGREEN, 4));
    dc.DrawLine(Distanz*(Offset)-KugelRadius, Distanz*(Offset),
                Distanz*(Offset)-KugelRadius, Distanz*(MaxY+Offset));
    dc.DrawLine(Distanz*(MaxX/2+Offset)-KugelRadius, Distanz*(Offset),
                Distanz*(MaxX/2+Offset)-KugelRadius, Distanz*(MaxY+Offset));
    dc.SetPen(wxPen(*wxBLACK, 1));
*/
}
