#include <wx/wx.h>
#include <wx/imaggif.h>


const int Distanz = 120;
const int Offset  = 1;
const int KugelRadius = 20;

class wxDrawApp : public wxApp {
    public:
        virtual bool OnInit();
};

class wxDrawFrame : public wxFrame {
    public:
        wxDrawFrame(const wxString& title, 
                         const wxPoint& pos, 
                         const wxSize& size);
        void OnMouseEvent(wxMouseEvent& event);
        void OnPaint(wxPaintEvent& event);

    private:
        DECLARE_EVENT_TABLE()
};

BEGIN_EVENT_TABLE( wxDrawFrame, wxFrame )
    EVT_PAINT(wxDrawFrame::OnPaint)
END_EVENT_TABLE()

IMPLEMENT_APP(wxDrawApp)

bool wxDrawApp::OnInit()
{
    wxDrawFrame *frame = new wxDrawFrame(
            wxT("Draw"), wxPoint(50,50), 
            wxSize(400, 300));

    frame->Show(TRUE);
    SetTopWindow(frame);
    return TRUE;
} 


wxDrawFrame::wxDrawFrame( const wxString& title, const wxPoint& pos, const wxSize& size )
    : wxFrame((wxFrame *)NULL, -1, title, pos, size)
{
}

void wxDrawFrame::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    dc.SetPen(*wxBLACK_PEN);
    dc.SetBrush(*wxRED_BRUSH);
    // Fensterausdehnung
    wxSize sz = GetClientSize();

    dc.DrawLine(0, 0, sz.x, sz.y);

    // Zentrieren
    int w = sz.x/2;
    int h = sz.y/2;
    int x = (sz.x)/4;
    int y = (sz.y)/4;

    wxRect rectToDraw(x, y, w, h);

    // For efficiency, do not draw if not exposed
    if (IsExposed(rectToDraw))
        dc.DrawRectangle(rectToDraw);
}
