#include <wx/wx.h>
#include "wxBermudaPanel.h"

BEGIN_EVENT_TABLE( wxBermudaPanel, wxPanel )
    EVT_MOUSE_EVENTS(wxBermudaPanel::OnMouseEvent)
    EVT_PAINT(wxBermudaPanel::OnPaint)
END_EVENT_TABLE()


wxBermudaPanel::wxBermudaPanel(wxWindow *parent)
    : wxPanel(parent, -1, wxDefaultPosition, wxSize(9*32, 7*32))
{
    imgVersion = true;
    flotte = new Flotte;
    feld   = new SpielFeld;
    if (imgVersion)
    {
        wxImageHandler *PngHandler = new wxPNGHandler();
        wxImage::AddHandler(PngHandler);
        imgSchiff.LoadFile("img/schiff.png", wxBITMAP_TYPE_PNG);
        imgLeer.LoadFile("img/leer.png", wxBITMAP_TYPE_PNG);
        for (int i=0; i<10; i++)
        {
            std::string filename = "img/mark" + std::to_string(i) + ".png";
            imgMark[i].LoadFile(filename.c_str(), wxBITMAP_TYPE_PNG);
        }
    }
}

wxBermudaPanel::~wxBermudaPanel()
{
    delete feld; feld = nullptr;
    delete flotte; flotte = nullptr;
}


#include <iostream>

void wxBermudaPanel::OnMouseEvent(wxMouseEvent& event)
{
    wxClientDC dc(this);
    if (event.LeftDown()) {
        wxPoint pt(event.GetLogicalPosition(dc));
        int x = pt.x / 32;
        int y = pt.y / 32;
        if (x>=0 && y>=0 && x < SpielFeld::X && y < SpielFeld::Y)
        {
            char zeichen = flotte->sucheSchiffe(x, y);
            feld->eintragen(x, y, zeichen);
            Refresh();
            // std::cout << pt.x << "," << pt.y << std::endl;
        }
    }
}

void wxBermudaPanel::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);
    for (int x=0; x<9; x++)
    {
        for (int y=0; y<7; y++)
        {
             char zeichen = feld->get(x, y);
             int posx = x * feldBreite;
             int posy = y * feldHoehe;
             if (imgVersion) {
                 if (zeichen==Flotte::SCHIFF)
                 {
                          dc.DrawBitmap(imgSchiff, posx, posy, true);
                 } else if (zeichen>='0' && zeichen<='9') {
                          int anzahl=zeichen-'0';
                          dc.DrawBitmap(imgMark[anzahl], posx, posy, true);
                 } else {
                          dc.DrawBitmap(imgLeer, posx, posy, true);
                 }
             } else {
                 dc.DrawText(zeichen, posx, posy);
             }
        }
    }
}

void wxBermudaPanel::neuesSpiel()
{
    delete feld; feld = new SpielFeld;
    delete flotte; flotte = new Flotte;
    Refresh();
}

/*
 * Die folgenden Methoden funktionieren nicht
wxSize 	wxBermudaPanel::GetMinClientSize ()
{
    std::cout << "getminclientsize" << std::endl;
    return wxSize(32*9, 32*7);
}

wxSize 	wxBermudaPanel::GetMinSize ()
{
    std::cout << "getminsize" << std::endl;
    return wxSize(32*9, 32*7);
}

wxSize 	GetSize ()
{
    return wxSize(32*9, 32*7);
}
*/
