// Ein Stack für eine beliebige Klasse T
#include <iostream>

template<class T> class Stack
{
public:
    // Konstruktor initialisiert die Konstanten MAXSTACK
    Stack() : MAXSTACK(256)
    {
        s = new T[MAXSTACK]; index=0;
    }
    ~Stack()
    {
        delete[] s;
    }
    bool pop(T *); // abholen
    bool push(T ); // drauflegen
private:
    const int MAXSTACK; // Konstante für die Stackgröße
    T *s;               // Der Stack selbst
    int index;          // aktuelle Position im Stack-Array
};

// Element vom Stack nehmen und freigeben
template<class T> bool Stack<T>::pop(T *get)
{
    if (index != 0)
    {
        *get = s[--index]; // Entnehme Element.
        return true;
    }
    return false; // Stack ist leer
}

// Neues Element auf den Stack schieben
template<class T> bool Stack<T>::push(T set)
{
    if (index < MAXSTACK)
    {
        s[index++] = set;  // Element auflegen
        return true;
    }
    return false; // Ist Stack überfüllt?
}

int main() // Testet den Stack
{
   Stack<int> intStack; // Lege einen Stack für ganze Zahlen an.
   intStack.push(8); // Testzahlen eintragen
   intStack.push(4);
   intStack.push(2);
   // Stack auslesen und auf dem Bildschirm anzeigen
   for (int i=0; i<3; i++)
   {
       int a;
       if (intStack.pop(&a))
       {
           std::cout << a << std::endl;
       }
   }
}

