#include <iostream>
#include <set>
#include <stdlib.h>

class Auto {
public:
     Auto(std::string pM, int pKw, float pV)
           { modell = pM; verbrauch=pV; kw = pKw; }
     bool operator<(const Auto& car) const
           { return kw < car.kw; }
     std::string getModell() { return modell; }
     int getKw() { return kw; }
     float getVerbrauch() { return verbrauch; }
private:
     std::string modell;
     int kw;
     float verbrauch;
};

class AutoVergleich {
public:
    bool operator() (Auto a, Auto b)
            { return a.getVerbrauch() < b.getVerbrauch(); }
};

int main()
{
    std::set<Auto, AutoVergleich> fuhrpark;
    fuhrpark.insert(Auto("R4", 23, 7.5));
    fuhrpark.insert(Auto("A4", 90, 6.5));
    fuhrpark.insert(Auto("C8", 75, 8.9));
    for (auto car : fuhrpark)
    {
         std::cout << car.getModell() << ": "
              << car.getKw() << " kW - "
              << car.getVerbrauch() << " l/100km"
              << std::endl;
    }
}

