#include <iostream>
#include <algorithm>
#include <set>

int main () {
    // Ausgangsmengen mit Initialisierung
    std::set <int>fuenfer;
    std::set <int>zehner;
    for (int i=1; i<5; i++) {
         fuenfer.insert(i*5);
         zehner.insert(i*10);
    }
    // Ergebnismengen
    std::set<int> durchschnitt;
    std::set<int> vereinigung;

    // Der Insert-Iterator für den Durchschnitt
    std::insert_iterator<std::set<int> >
            dsInsertIt(durchschnitt, durchschnitt.begin());
    // Ein set ist immer sortiert.
    // Bilde Schnittmenge
    std::set_intersection (
            fuenfer.begin(), fuenfer.end(),
            zehner.begin(), zehner.end(),
            dsInsertIt);
    // Bilde Vereinigung.
    // Der Insert-Iterator wird per inserter gebildet.
    std::set_union (
            fuenfer.begin(), fuenfer.end(),
            zehner.begin(), zehner.end(),
            inserter(vereinigung, vereinigung.begin()));

    // Gebe die Ergebnisse aus
    std::cout << "Der Durchschnitt hat "
              << durchschnitt.size()
              << " Elemente." << std::endl;
    for (auto it=durchschnitt.begin();
              it!=durchschnitt.end(); ++it)
    {
        std::cout << ' ' << *it;
    }
    std::cout << std::endl;
    std::cout << "Die Vereinigung hat "
              << vereinigung.size()
              << " Elemente." << std::endl;
    for (auto it=vereinigung.begin();
              it!=vereinigung.end(); ++it)
    {
        std::cout << ' ' << *it;
    }
    std::cout << std::endl;
    return 0;
}

