#include <iostream>
#include <algorithm>
#include <set>
using namespace std;

int main () {
    // Ausgangsmengen mit Initialisierung
    set <int>fuenfer;
    set <int>zehner;
    for (int i=1; i<5; i++) {
         fuenfer.insert(i*5);
         zehner.insert(i*10);
    }
    // Ergebnismengen
    set<int> durchschnitt;
    set<int> vereinigung;

    // Der Insert-Iterator für den Durchschnitt
    insert_iterator<set<int> > dsInsertIt(durchschnitt,
                                          durchschnitt.begin());
    // Die Mengen müssen sortiert sein, was bei set immer gilt.
    // Bilde Schnittmenge
    set_intersection (
            fuenfer.begin(), fuenfer.end(),
            zehner.begin(), zehner.end(),
            dsInsertIt);
    // Bilde Vereinigung.
    // Der Insert-Iterator wird per inserter gebildet.
    set_union (
            fuenfer.begin(), fuenfer.end(),
            zehner.begin(), zehner.end(),
            inserter(vereinigung, vereinigung.begin()));

    // Gebe die Ergebnisse aus
    cout << "Der Durchschnitt hat " << durchschnitt.size()
            << " Elemente." << endl;
    for (set<int>::iterator it=durchschnitt.begin();
            it!=durchschnitt.end(); ++it)
    {
        cout << ' ' << *it;
    }
    cout << endl;
    cout << "Die Vereinigung hat " << vereinigung.size()
            << " Elemente." << endl;
    for (set<int>::iterator it=vereinigung.begin();
            it!=vereinigung.end(); ++it)
    {
        cout << ' ' << *it;
    }
    cout << endl;
    return 0;
}

