/**
 * Arnold Willemer: C++ für Dummies
 *
 * Aufgabe: Ermitteln Sie durch eine Millionen Simulationen, wie
 * wahrscheinlich das Auftreten benachbarter Zahlen bei
 * Lottoziehungen sind.
 */

#include <iostream>
#include <algorithm>

const int MAXLOTTO = 6;

/**
 * Die Funktion zieht Lottozahlen und sorgt dafür, dass keine
 * Zahl doppelt gezogen wird.
 */
void ziehe(int lotto[])
{
    for (int i=0; i<MAXLOTTO; i++)
    {
         lotto[i] = rand() % 49 + 1;
         // Ist die Zahl bereits gezogen wurden?
         for (int j=0; j<i; j++)
         {
             if (lotto[i]==lotto[j])
             {
                 i--;  // Wiederhole die Ziehung
             }
         }
    }
}

/**
 * Die Funktion stellt fest, ob es bei dieser Ziehung benachbarte
 * Zahlen gegeben hat. Voraussetzung ist, dass die Lottozahlen
 * aufsteigend sortiert sind.
 */
bool istPaar(const int lotto[])
{
    for (int i=0; i<MAXLOTTO-1; i++)
    {
        if (lotto[i]+1 == lotto[i+1])
        {
            return true;
        }
    }
    return false;
}

int main()
{
    int lotto[MAXLOTTO];
    srand(time(0));
    double simulationen = 1000000.0;
    double paare = 0.0;
    for (int i=0; i<simulationen; i++)
    {
        ziehe(lotto);
        std::sort(lotto, lotto+MAXLOTTO);
        if (istPaar(lotto))
        {
             paare++;
        }
    }
    std::cout << paare / simulationen << std::endl;
}

