/**
 * Koordinate ist die Basisklasse für ein Schiff.
 * Übung:
    Ergänzen Sie die Klasse Koordinate um eine Methode findeRichtung,
    die feststellt, in welcher Richtung sich eine andere Koordinate auf einer
    der Suchachsen (waagerecht, senkrecht oder diagonal) befindet.
    Das Ziel soll es sein, diese Methode im Zuge der Peilung nach
    anderen Schiffen zu benutzen.
 */
#include <iostream>

class Koordinate
{
    int x;
    int y;
    int richtung;
public:
    Koordinate(int x, int y) : x{x}, y{y} {}
    bool operator==(Koordinate pos)
    {
        return this->x==pos.x && this->y==pos.y;
    }
    int findeRichtung(Koordinate fremd)
    {
        richtung = 0;
        if (fremd.x == x && fremd.y < y) { // oben
            richtung = 1;
        } else if (fremd.x == x && fremd.y > y) { // unten
            richtung = 2;
        } else if (fremd.x > x && fremd.y == y) { // rechts
            richtung = 3;
        } else if (fremd.x < x && fremd.y == y) { // links
            richtung = 4;
        } else if (fremd.x - x == fremd.y - y) { // diagonal
            if (fremd.x < x) {
                richtung = 5; // links oben
            } else {
                richtung = 6; // rechts unten
            }
        } else if (fremd.x - x == -(fremd.y - y)) { // diagonal
            if (fremd.x < x) {
                richtung = 7;  // links unten
            } else {
                richtung = 8;  // rechts oben
            }
        }
        return richtung;
    }
};

int main()
{
    Koordinate pkt(5,4);
    std::cout << pkt.findeRichtung(Koordinate(2,2)) << std::endl;
}

