#include <iostream>

class DatenKlasse
{
public:
    DatenKlasse() // Konstruktor: erzeugt externe Daten
    {
        zeiger = new int;
        *zeiger = 5;
    }
    ~DatenKlasse() // Destruktor: gibt externe Daten frei
    {
        delete zeiger;
    }

    DatenKlasse& operator=(const DatenKlasse& data)
    {
        std::cout << "Zuweisungsoperator" << std::endl;
        if (&data!=this)
        {
            delete zeiger;       // alten Speicher freigeben
            zeiger = new int;    // neuen Speicher anlegen
            *zeiger = *data.zeiger; // externe Daten kopieren
            // normale Datenelemente auch kopieren
            sonstiges = data.sonstiges;
        }
        return *this;
    }

    int  getData() {return *zeiger; }
    void setData(int wert) {*zeiger=wert; }
private:
    int sonstiges; // steht für die Nicht-Zeiger-Datenelemente
    int *zeiger;   // Zeiger, also Kopierkonstruktor notwendig
};

int main()
{
    DatenKlasse objekt;
    DatenKlasse ziel;
    ziel = objekt;     // Zuweisungsoperator!
    objekt.setData(7);
    ziel.setData(9);
    std::cout << objekt.getData() << std::endl;
    std::cout << ziel.getData() << std::endl;
}

