#include <iostream>

class Mahlzeit
{
public:
    virtual double kostet() = 0;
    virtual std::string getName() = 0;
};

class Kitt : public Mahlzeit
{
public:
    double kostet() {
        return 0.50;
    }
};

class Schnee : public Kitt
{
public:
    std::string getName() {
        return "Kartoffelschnee";
    }
};

class Purree : public Kitt
{
public:
    std::string getName() {
        return "Purree de Pomes";
    }
};


class Suppe : public Mahlzeit
{
public:
    virtual double kostet()
    {   
        return 0.70;
    }
    virtual std::string getName() = 0;
};

class Tomatensuppe : public Suppe
{
public:
    std::string getName()
    {
        return "Tomatensuppe";
    }
};

class Gulaschsuppe : public Suppe
{
public:
    std::string getName()
    {
        return "Gulaschsuppe";
    }
};

class Erbsensuppe : public Suppe
{
public:
    std::string getName()
    {
        return "Erbsensuppe";
    }
    double kostet()
    {
        return Suppe::kostet() + 0.01;
    }
};

int main()
{
    Mahlzeit *karte[5];
    karte[0] = new Tomatensuppe;
    karte[1] = new Schnee;
    karte[2] = new Gulaschsuppe;
    karte[3] = new Purree;
    karte[4] = new Erbsensuppe;
    double kosten = 0.0;
    for (Mahlzeit *gedeck : karte) {
        std::cout << gedeck->getName() << ": "
                  << gedeck->kostet() << std::endl;
    }
}

