// Programm zur Demonstration eines Kopierkonstruktors
#include <iostream>

class DatenKlasse
{
public:
    DatenKlasse() // Konstruktor: erzeugt externe Daten
    {
        zeiger = new int;
        *zeiger = 5;
    }
    ~DatenKlasse() // Destruktor: gibt externe Daten frei
    {
        delete zeiger;
        zeiger = 0;
    }
    DatenKlasse(const DatenKlasse& daten) // Kopierkonstruktor
    {
        // Zur Demonstration meldet er sich.
        std::cout << "Kopierkonstruktor" << std::endl;
        // Externe Daten erzeugen und kopieren
        zeiger = new int;
        *zeiger = daten.getData();
        // Normale Datenelemente auch kopieren
        sonstiges = daten.sonstiges;
    }
    // set und get nur zum Test - musste sonst zeiger pruefen
    void setData(int data) { *zeiger = data; }
    int getData() const { return *zeiger; }
private:
    int *zeiger;   // Zeiger, also Kopierkonstruktor notwendig
    int sonstiges; // steht für die Nicht-Zeiger-Datenelemente
};

// Die Funktion dient nur zur Demonstration. Da der Parameter
// per Wert übergeben wird, wird beim Aufruf der
// Kopierkonstruktor aufgerufen.
void tuIrgendwas(DatenKlasse para)
{
    std::cout << "tuIrgendwas:" << para.getData() << std::endl;
}

// Hauptprogramm zum Testen
int main()
{
    DatenKlasse objekt;
    objekt.setData(7);
    // Hier wird der Kopierkonstruktor aktiv.
    tuIrgendwas(objekt);
    std::cout << objekt.getData() << std::endl;
}

