#include <iostream>

class Bruch
{
public:
    int zaehler;
    int nenner;
    // Der Konstruktor gibt seine Parameter an die Initialisierer
    Bruch(int zaehler, int nenner) : zaehler{zaehler}, nenner{nenner}
    { kuerzen(); }
    // Konvertierungskonstruktor konvertiert int
    Bruch(int wert) : zaehler(wert), nenner(1)
    { }
    Bruch multipliziere(Bruch zahl);
    Bruch operator*(Bruch op);
    void kuerzen();
private:
    int ggT(int a, int b);
};

Bruch Bruch::multipliziere(Bruch zahl)
{
    return Bruch(zaehler*zahl.zaehler, zahl.nenner* nenner);
}

Bruch Bruch::operator*(Bruch op)
{
    return Bruch(op.zaehler*zaehler, op.nenner*nenner);
}

void Bruch::kuerzen()
{
     int ggt = ggT(zaehler, nenner);
     zaehler/=ggt;
     nenner /=ggt;
}

int Bruch::ggT(int a, int b)
{
    if (a==0)
        return b;
    while (b>0)
    {
        if (b>a)
        {
           int hilf = a;
           a = b;
           b = hilf;
        }
        a = a - b;
    }
    return a;
}

Bruch operator*(long wert, Bruch bruch)
{
    return Bruch(wert) * bruch;
}
     
int main()
{
    Bruch meinAnteil(3, 4);
    int beute = 100;
    // Bruch meineBeute = meinAnteil.multipliziere(beute);
    Bruch meineBeute = meinAnteil * beute;
    std::cout << meineBeute.zaehler << "/"
              << meineBeute.nenner << std::endl;
    meineBeute = Bruch(beute) * meinAnteil;
    meineBeute = beute * meinAnteil;
}

