/**
 * Fibonacci-Berechnung rekursiv und iterativ.
 * Es wird die Ausführungszeit gemessen.
 * Arnold Willemer 2019
 */
#include <iostream>
#include <ctime>

long fiborekursiv(long n) {
    if (n==0 || n==1)
        return 1;
    else
        return fiborekursiv(n-1)+fiborekursiv(n-2);
}

long fiboiterativ(long n)
{
    long akt=1, letzt=1, vorletzt=1;
    for (int i=1; i<n; i++)
    {
        akt = letzt + vorletzt;
        vorletzt = letzt;
        letzt = akt;
    }
    return akt;
}

int main()
{
    clock_t start, end;
    start = clock();
    std::cout << fiboiterativ(50) << std::endl;
    end = clock();
    std::cout << end-start << std::endl;
    start = clock();
    std::cout << fiborekursiv(50) << std::endl;
    end = clock();
    std::cout << end-start << std::endl;

}

