#include <iostream>
#include <string>
#include <sqlite3.h>
using namespace std;

/**
 * Wird von sqlite3_exec verwendet, insbesondere, um bei SELECTs die
 * Daten auszugeben.
 */
int callback(void *NotUsed, int argc, char **argv, char **azColName)
{
    for(int i = 0; i<argc; i++) {
        cout << azColName[i] << " = " << (argv[i]?argv[i]:"NULL") << endl;
    }
    return 0;
}

int createTable(sqlite3 *db)
{
    const char *sqlBefehl = "CREATE TABLE PERSON("  \
        "ID             INT PRIMARY KEY NOT NULL," \
        "NAME           VARCHAR         NOT NULL," \
        "ADRESSE        CHAR(50)," \
        "GEHALT         REAL );";
    char *fehlerMeldung = nullptr;
    int rc = sqlite3_exec(db, sqlBefehl, callback, 0, &fehlerMeldung);
    if (rc != SQLITE_OK)
    {
        cerr << "SQL Fehler: " << fehlerMeldung << endl;
        sqlite3_free(fehlerMeldung);
        return rc;
    }
    return SQLITE_OK;
}

class Person 
{
public:
     int id;
     string name;
     string adresse;
     double gehalt;
};

int insert(sqlite3 *db, Person* person)
{
    // "INSERT INTO PERSON (ID, NAME, ADRESSE, GEHALT) " 
    // "VALUES (1, 'Otto', 'Emden', 2.00 ) "
    string sqlString = "INSERT INTO PERSON " \
        "(ID,NAME,ADRESSE,GEHALT) VALUES ("
        +to_string(person->id)+", '"
        +person->name+"', '"+person->adresse+"', "
        +to_string(person->gehalt)+");";
    char *fehlerMeldung = nullptr;
    int rc = sqlite3_exec(db, sqlString.c_str(), callback, 0, &fehlerMeldung);
    if (rc != SQLITE_OK)
    {
        cerr <<  "SQL Fehler: " << fehlerMeldung << endl;
        sqlite3_free(fehlerMeldung);
        return rc;
    }
    return SQLITE_OK;
}

int select(sqlite3 *db)
{
    const char* sqlBefehl =  "SELECT * from PERSON";
    char *fehlerMeldung = nullptr;
    int rc = sqlite3_exec(db, sqlBefehl, callback, 0, &fehlerMeldung);
    if (rc != SQLITE_OK)
    {
        cerr << "SQL Fehler: " << fehlerMeldung << endl;
        sqlite3_free(fehlerMeldung);
    }
    return SQLITE_OK;
}

#include <vector>

int select(sqlite3 *db, vector<Person> &personen)
{
    sqlite3_stmt *stmt;
    const char *sql = "SELECT ID, NAME FROM PERSON";
    int rc = sqlite3_prepare_v2(db, sql, -1, &stmt, 0);
    if (rc != SQLITE_OK)
    {
        cerr << "SQL Fehler: " << sqlite3_errmsg(db) << endl;
        return rc;
    }
    while ((rc = sqlite3_step(stmt)) == SQLITE_ROW) {
        int id           = sqlite3_column_int (stmt, 0);
        // Texte werden in UTF-8 gespeichert. Darum wird ein unsigned char*
        // als Rückgabewert verwendet. Um diesen in einen std::string
        // umzuwandeln, muss die Form des reinterpre_cast verwendet werden.
        const unsigned char* utf8cstring = sqlite3_column_text(stmt, 1);
        string str = std::string(reinterpret_cast<const char*>(utf8cstring));
        Person person = {id, str, "hier", 2.4};
        personen.push_back(person);
    }
    if (rc != SQLITE_DONE) {
        cerr << "SQL Fehler: " << sqlite3_errmsg(db) << endl;
    }
    sqlite3_finalize(stmt);
    return rc;
}


int main()
{
    sqlite3* db;
    if(sqlite3_open("datenbank.db", &db) != SQLITE_OK)
    {
        cerr << "Fehler beim Öffnen: " << sqlite3_errmsg(db) << endl;
        return 1; // Fehlernummer
    }
    // Tue etwas mit der Datenbank
    createTable(db);
    Person personen[] =
        {
            {7, "James Bond", "London", 10E6},
            {22, "Otto", "Emden", 2.0},
            {23, "Ännchen", "Tönsfeld", 2.0},
        };
    for (Person person : personen)
    {
        insert(db, &person);
    }
    select(db);

    vector<Person> liste;
    select(db, liste);
    
    sqlite3_close(db);
    return 0; // alles ok
}

