/*
 * mysqlcppconn
 */

#include <iostream>
#include <mysql_connection.h>
#include <cppconn/driver.h>
#include <cppconn/exception.h>
#include <cppconn/resultset.h>
#include <cppconn/statement.h>

using namespace std;

int main(int argc, char **argv)
{
    try{
        sql::Driver *driver;
        sql::Connection *con;
        sql::Statement *stmt;
        sql::ResultSet *res;

        driver = get_driver_instance();
        con = driver->connect("tcp://DOMAIN:3306", "DBUSER", "PASSWORD");
        con->setSchema("DBNAME");

        stmt = con->createStatement();
        res = stmt->executeQuery("SELECT * FROM country");
        while (res->next()) {
            cout << "Land: ";
            cout << res->getString(2) << " (";
            cout << res->getString(3) << ")" << endl;
        }
        delete res;
        delete stmt;
        delete con;
    }
    catch(sql::SQLException &err)
    {
        cout << "ERROR: " << err.what() << endl;
    }
    return 0;
}

