
/*
 * CppDB für PostgreSQL
 */

//                                                                             
//  Copyright (C) 2010-2011  Artyom Beilis (Tonkikh) <artyomtnk@yahoo.com>     
//                                                                             
//  Distributed under:
//
//                   the Boost Software License, Version 1.0.
//              (See accompanying file LICENSE_1_0.txt or copy at 
//                     http://www.boost.org/LICENSE_1_0.txt)
//
//  or (at your opinion) under:
//
//                               The MIT License
//                 (See accompanying file MIT.txt or a copy at
//              http://www.opensource.org/licenses/mit-license.php)
//
#include <cppdb/frontend.h>
#include <iostream>
#include <vector>

class Person
{
public:
     int id;
     std::string name;
     std::string adresse;
     double gehalt;
};

int createTable(cppdb::session db)
{
    db << "DROP TABLE IF EXISTS person1" << cppdb::exec;
    db << "CREATE TABLE person1 ( "
            "ID             INT PRIMARY KEY NOT NULL,"
            "NAME           VARCHAR         NOT NULL,"
            "ADRESSE        CHAR(50),"
            "GEHALT         REAL )  " << cppdb::exec;
}

int insert(cppdb::session db, Person* person)
{
    cppdb::statement stat;
    stat = db <<
            "INSERT INTO person1 (ID,NAME,ADRESSE,GEHALT) "
            "VALUES(?,?,?,?) "
            << person->id << person->name
            << person->adresse << person->gehalt;
    stat.exec();
}

int select(cppdb::session db, std::vector<Person> &personen)
{
    cppdb::result res = db 
            << "SELECT ID,NAME,ADRESSE,GEHALT FROM person1";
    while(res.next()) {
        Person person;
        res >> person.id >> person.name >> person.adresse >> person.gehalt;
        personen.push_back(person);
    }
}

Person* select(cppdb::session db, int id)
{
    Person *person = nullptr;
    cppdb::result res = db
            << "SELECT NAME,ADRESSE,GEHALT FROM person1 WHERE ID=?"
            << id << cppdb::row;
    if(!res.empty()) {
        person = new Person;
        person->id = id;
        person->gehalt = res.get<double>("GEHALT");
        person->adresse = res.get<std::string>("ADRESSE");
        person->name = res.get<std::string>(0);
    }
    return person;
}

int main()
{
    try
    {
        cppdb::session db("postgresql:host=localhost;"
                "dbname=person;user=person;password='person'");
        createTable(db);
        Person personen[] =
            {
                {7, "James Bond", "London", 10E6},
                {22, "Otto", "Emden", 2.0},
                {23, "Ännchen", "Tötensen", 0.0},
            };
        for (Person person : personen)
        {
            insert(db, &person);
        }
/*
        stat.reset();
        stat.bind(22);
        stat.bind("Otto");
        stat.bind_null(); // Adresse auf NULL
        stat.bind(2.0);
        stat.exec();
*/
        std::vector<Person> personvec;
        select(db, personvec);
        for (Person p : personvec)
        {
            std::cout << p.id << " " << p.name << " "
                      << p.adresse << " " << p.gehalt << std::endl;
        }

        Person *p = select(db, 22);
        if (p) {
            std::cout << p->id << " " << p->name << " "
            << p->adresse << " " << p->gehalt << std::endl;
        }
    }
    catch(std::exception const &e) {
            std::cerr << "ERROR: " << e.what() << std::endl;
            return 1;
    }
    return 0;
}

