#include <fstream>
#include <string>
#include <cstring>
#include <iostream>
using namespace std;

class Daten
{
public:
    Daten(const char *para, int alter)
    {
        strncpy(name, para, sizeof(name));
        name[sizeof(name)-1] = 0;
        this->alter = alter;
    }
    void zeige()
    {
        cout << name << " " << alter << endl;
    }
private:
    char name[20];
    int alter;
};

int main(int argc, char**argv)
{
    Daten kfz("Rolls Royce mit Anhängerkupplung", 30);
    Daten person("Anna", 25);
    // Objekt in Datei speichern
    fstream schreib("testdatei", ios::out|ios::binary);
    schreib.write((char *)&kfz, sizeof(kfz));
    schreib.write((char *)&person, sizeof(person));
    schreib.close();
    // Dateiinhalt in Objekt lesen
    Daten kfz1("nix", 1), person1("gar", 2);
    fstream lese("testdatei", ios::in|ios::binary);
    lese.read((char *)&kfz1, sizeof(kfz));
    lese.read((char *)&person1, sizeof(person));
    kfz1.zeige();
    person1.zeige();

    Daten daten("Mietzekatze", 12);
    fstream datei;
    // Melde Exceptions an:
    datei.exceptions(fstream::eofbit
                   | fstream::failbit
                   | fstream::badbit);
    try
    {
        datei.open("testdatei", ios::in|ios::out|ios::binary);
        datei.seekp(0, ios::end); // 2*sizeof(Daten));
        datei.write((char *)&daten, sizeof(daten));
        int pos = 0;
        bool ende = false;
        do
        {
            datei.seekp(pos*sizeof(Daten));
            datei.read((char *)&daten, sizeof(Daten));
            if (datei.good())
                daten.zeige();
            else
                ende = true;
            pos++;
            cout << pos << endl;
        } while (!ende && !datei.eof());
    } catch(const fstream::failure& e) {
        cout << "Exception" << endl;
        cout << "Grund: " << e.what() << endl;
        cout << "Fehlernummer: " << e.code() << endl;
    }
}

