#include <fstream>
#include <iostream>
#include <vector>

class Koordinate
{
public:
    Koordinate(int x, int y)
    {
        this->x = x; this->y = y;
    }
    int getX() { return x; }
    int getY() { return y; }
private:
    int x = 0;
    int y = 0;
};

void sichereVector(std::fstream &datei,
                   const std::vector<Koordinate> &v)
{
    datei << v.size() << std::endl;
    for (Koordinate k : v)
    {
        datei << k.getX() << " " << k.getY() << std::endl;
    }
}

int sichern(const std::vector<Koordinate> &schiffe,
            const std::vector<Koordinate> &versuche)
{
    std::fstream datei("bermuda.dat", std::ios::out);
    sichereVector(datei, schiffe);
    sichereVector(datei, versuche);
    datei.close();
}

int ladeVector(std::fstream &datei, std::vector<Koordinate> &v)
{
    int anzahl, x, y;
    datei >> anzahl;
    for (int i=0; i<anzahl; i++)
    {
        datei >> x;
        datei >> y;
        // std::cout << x << "," << y << std::endl;
        v.push_back(Koordinate(x, y));
    }
    return anzahl;
}

int laden(std::vector<Koordinate> &flotte, std::vector<Koordinate> &zuege)
{
    std::fstream datei("bermuda.dat", std::ios::in);
    ladeVector(datei, flotte);
    return ladeVector(datei, zuege);
}

int main()
{
    std::vector<Koordinate> flotte = { {1,3}, {4,2}, {0,5}, {8,5}};
    std::vector<Koordinate> spielzuege = { {4,3}, {0,2}};
    sichern(flotte, spielzuege);
    std::vector<Koordinate> neuflotte;
    std::vector<Koordinate> neuzuege;
    int zugzahl = laden(neuflotte, neuzuege);
    std::cout << "Schiffe" << std::endl;
    for (auto koord : neuflotte)
    {
        std::cout << koord.getX() << "/" << koord.getY() << std::endl;
    }
    std::cout << "Versuche" << std::endl;
    for (auto koord : neuzuege)
    {
        std::cout << koord.getX() << "/" << koord.getY() << std::endl;
    }
}
