
#include <stdlib.h>
#include "spielfeld.h"
#include "flotte.h"

Flotte::Flotte()
{
    for(int i=0; i<MAXSCHIFF; i++)
    {
        bool neueZahl;
        do {
            neueZahl = true; // wird schon neu sein!
            for (int j=0; neueZahl && j<i; j++)
            {
                if (flotte[j]==flotte[i])
                {
                    // Doppelter gefunden, neues Schiff!
                    flotte[i] = Schiff();
                    neueZahl = false; // wiederhole!
                }
            }
        } while (!neueZahl);
    }
}

int Flotte::getSchiffIndex(int x, int y)
{
    for (int i=0; i<MAXSCHIFF; i++)
    {
        if (flotte[i]==Koordinate(x, y))
        {
            return i;
        }
    }
    return -1;
}

bool Flotte::istHierEinSchiff(int x, int y)
{
    return getSchiffIndex(x, y) >= 0;
}

int Flotte::suche(int x, int y, int xdiff, int ydiff)
{
    x+=xdiff;
    y+=ydiff;
    while(x<SpielFeld::X && x>=0 && y<SpielFeld::Y && y>=0)
    {
        if (istHierEinSchiff(x, y))
        {
            return 1;
        }
        x+=xdiff;
        y+=ydiff;
    }
    return 0;
}

char Flotte::sucheSchiffe(int x, int y)
{
    int anzahl=0;
    int schiffindex = getSchiffIndex(x, y);
    if (schiffindex>=0)
    {
        flotte[schiffindex].wurdeGefunden();
        return SCHIFF;
    }
    else
    {
        for (int i=-1; i<=1; i++)
        {
            for (int j=-1; j<=1; j++)
            {
                if (!(i==0 && j==0))
                {
                    anzahl += suche(x, y, i, j);
                }
            }
        }
    }
    return '0' + anzahl;
}

bool Flotte::istSpielGewonnen()
{
    for(int i=0; i<MAXSCHIFF; i++)
    {
        if (!flotte[i].istGefunden())
        {
            return false;
        }
    }
    return true;
}

