#include <iostream>
#include <stdlib.h>

/**
 * SpielFeld enthält die Spielanzeige für den Spielverlauf.
 * Treffer und Suchen werden dort verwaltet, ggf. auch Markierungen
 */
class SpielFeld
{
public:
    static const int X=9;
    static const int Y=7;
    SpielFeld();
    void zeige();
    void eintragen(int x, int y, char symbol);
    char get(int x, int y);
    bool istKoordinateGueltig(int x, int y);
private:
    char spielFeld[X][Y];
};

SpielFeld::SpielFeld()
{
    for (int x=0; x<X; x++)
    {
        for (int y=0; y<Y; y++)
        {
            spielFeld[x][y] = '.';
        }
    }
}

void SpielFeld::zeige()
{
    std::cout << "     1  2  3  4  5  6  7  8  9" << std::endl;
    for (int y=0; y<Y; y++)
    {
        std::cout << (char)('A'+y) << "  ";
        for (int x=0; x<X; x++)
        {
            std::cout << "  " << get(x, y) ;
        }
        std::cout << "   " << (char)('A'+y);
        std::cout << std::endl;
    }
    std::cout << "     1  2  3  4  5  6  7  8  9" << std::endl;
}

bool SpielFeld::istKoordinateGueltig(int x, int y)
{
    return x>=0 && y>=0 && x<X && y<Y;
}

void SpielFeld::eintragen(int x, int y, char symbol)
{
    if (istKoordinateGueltig(x, y))
    {
        spielFeld[x][y] = symbol;
    }
}

char SpielFeld::get(int x, int y)
{
    if (istKoordinateGueltig(x, y))
    {
        return spielFeld[x][y];
    }
    return 0;
}

/**
 * Koordinate ist die Basisklasse für ein Schiff.
 */
class Koordinate
{
    int x;
    int y;
public:
    Koordinate(int x, int y) : x{x}, y{y} {}
    bool operator==(Koordinate pos)
    {
        return this->x==pos.x && this->y==pos.y;
    }
};

/**
 * Das Schiff ist eine Koordinate mit einer gefunden-Flag
 */
class Schiff : public Koordinate
{
    bool gefunden = false;
public:
    // Schiff(int x, int y) : Koordinate(x, y) {}
    Schiff() :
        Koordinate(rand() % SpielFeld::X, rand() % SpielFeld::Y)
    {
    }
    bool istGefunden() { return gefunden; }
    void wurdeGefunden() { gefunden = true; }
};

/**
 * Eine Flotte enthält mehrere Schiffe.
 */
class Flotte
{
public:
     static const int MAXSCHIFF=4;
     static const char SCHIFF = 'X';
     Flotte();
     char sucheSchiffe(int x, int y);
     bool istSpielGewonnen();
private:
     Schiff flotte[MAXSCHIFF];
     int suche(int x, int y, int xdiff, int ydiff);
     bool istHierEinSchiff(int x, int y);
     int getSchiffIndex(int x, int y);
};

Flotte::Flotte()
{
    for(int i=0; i<MAXSCHIFF; i++)
    {
        bool neueZahl;
        do {
            neueZahl = true; // wird schon neu sein!
            for (int j=0; neueZahl && j<i; j++)
            {
                if (flotte[j]==flotte[i])
                {
                    // Doppelter gefunden, neues Schiff!
                    flotte[i] = Schiff();
                    neueZahl = false; // wiederhole!
                }
            }
        } while (!neueZahl);
    }
}

int Flotte::getSchiffIndex(int x, int y)
{
    for (int i=0; i<MAXSCHIFF; i++)
    {
        if (flotte[i]==Koordinate(x, y))
        {
            return i;
        }
    }
    return -1;
}

bool Flotte::istHierEinSchiff(int x, int y)
{
    return getSchiffIndex(x, y) >= 0;
}

int Flotte::suche(int x, int y, int xdiff, int ydiff)
{
    x+=xdiff;
    y+=ydiff;
    while(x<SpielFeld::X && x>=0 && y<SpielFeld::Y && y>=0)
    {
        if (istHierEinSchiff(x, y))
        {
            return 1;
        }
        x+=xdiff;
        y+=ydiff;
    }
    return 0;
}

char Flotte::sucheSchiffe(int x, int y)
{
    int anzahl=0;
    int schiffindex = getSchiffIndex(x, y);
    if (schiffindex>=0)
    {
        flotte[schiffindex].wurdeGefunden();
        return SCHIFF;
    }
    else
    {
        for (int i=-1; i<=1; i++)
        {
            for (int j=-1; j<=1; j++)
            {
                if (!(i==0 && j==0))
                {
                    anzahl += suche(x, y, i, j);
                }
            }
        }
    }
    return '0' + anzahl;
}

bool Flotte::istSpielGewonnen()
{
    for(int i=0; i<MAXSCHIFF; i++)
    {
        if (!flotte[i].istGefunden())
        {
            return false;
        }
    }
    return true;
}

void gebeKoordinateEin(int *x, int *y)
{
char cx, cy;

    std::cin >> cx >> cy;
    *x = cx - '1';
    *y = cy - 'A';
}

int main()
{
    srand(time(0));
    Flotte flotte;
    SpielFeld spielFeld;
    bool spielEnde = false;
    do
    {
        spielFeld.zeige();
        int x, y;
        gebeKoordinateEin(&x, &y);
        if (spielFeld.istKoordinateGueltig(x, y))
        {
            char symbol = flotte.sucheSchiffe(x, y);
            spielFeld.eintragen(x, y, symbol);
            spielEnde = flotte.istSpielGewonnen();
        }
        else
        {
            spielEnde = true;
        }
    }
    while (!spielEnde);
}

