#include <iostream>
using namespace std;
#include <stdlib.h>

const int X=9;
const int Y=7;
const int MAXSCHIFF=4;
const char SCHIFF = 'X';

struct Schiff
{
    int x;
    int y;
    bool gefunden;
};


void zeigeSpielFeld(char spielFeld[X][Y])
{
    cout << "     1  2  3  4  5  6  7  8  9" << endl;
    for (int y=0; y<Y; y++)
    {
        cout << (char)('A'+y) << "  ";
        for (int x=0; x<X; x++)
        {
            cout << "  " << spielFeld[x][y] ;
        }
        cout << endl;
    }
}

void initAnzeige(char spielFeld[X][Y])
{
    for (int x=0; x<X; x++)
    {
        for (int y=0; y<Y; y++)
        {
            spielFeld[x][y] = '.';
        }
    }
}

void initSchiffe(Schiff flotte[])
{

    // srand(0); So erscheinen immer gleiche Zahlenreihen
    srand(time(0));  // So wird es jedesmal anders
    for(int i=0; i<MAXSCHIFF; i++)
    {
        flotte[i].gefunden = false;
        bool neueZahl = true;
        do
        {
            flotte[i].x = rand() % X;
            flotte[i].y = rand() % Y;
            neueZahl = true;
            for (int j=0; j<i; j++)
            {
                if (flotte[j].x==flotte[i].x
                   && flotte[j].y==flotte[i].y)
                {
                    neueZahl = false;
                }
            }
        } while (!neueZahl);
    }
    for (int i=0; i<MAXSCHIFF; i++)
    {
        cout << flotte[i].x << "," << flotte[i].y << " ";
    }
    cout << endl;
}

void initSpielFeld(char SpielFeld[X][Y], Schiff flotte[])
{
    initAnzeige(SpielFeld);
    initSchiffe(flotte);
}

int gebeSchiffIndex(Schiff flotte[], int x, int y)
{
    for (int i=0; i<MAXSCHIFF; i++)
    {
        if (flotte[i].x==x && flotte[i].y==y)
        {
            return i;
        }
    }
    return -1;
}

bool istHierEinSchiff(Schiff flotte[], int x, int y)
// Ermittele, ob an der aktuellen Position ein Schiff ist.
{
    return gebeSchiffIndex(flotte, x, y) >= 0;
}

int suche(Schiff flotte[], int x, int y, int xdiff, int ydiff)
{
    x+=xdiff;
    y+=ydiff;
    while(x<X && x>=0 && y<Y && y>=0)
    {
        if (istHierEinSchiff(flotte, x, y))
        {
            return 1;
        }
        x+=xdiff;
        y+=ydiff;
    }
    return 0;
}

char sucheSchiffe(Schiff flotte[], int x, int y)
{
    int anzahl=0;
    int schiffindex = gebeSchiffIndex(flotte, x, y);
    if (schiffindex>=0)
    {
        flotte[schiffindex].gefunden = true;
        return SCHIFF;
    }
    else
    {
        for (int i=-1; i<=1; i++)
        {
            for (int j=-1; j<=1; j++)
            {
                if (!(i==0 && j==0))
                {
                    anzahl += suche(flotte, x, y, i, j);
                }
            }
        }
    }
    return '0' + anzahl;
}


void gebeKoordinateEin(int *x, int *y)
{
char cx, cy;

    cin >> cx >> cy;
    *x = cx - '1';
    *y = cy - 'A';
}

bool istSpielGewonnen(Schiff flotte[])
{
    for(int i=0; i<MAXSCHIFF; i++)
    {
        if (!flotte[i].gefunden)
        {
            return false;
        }
    }
    return true;
}

bool istKoordinateGueltig(int x, int y)
{
    return x>=0 && y>=0 && x<X && y<Y;
}

void eintragen(char anzeige[X][Y], int x, int y, char symbol)
{
    if (istKoordinateGueltig(x, y))
    {
        anzeige[x][y] = symbol;
    }
}

int main()
{
    Schiff flotte[MAXSCHIFF];
    char spielFeld[X][Y];
    initSpielFeld(spielFeld, flotte);
    bool spielEnde = false;
    do
    {
        zeigeSpielFeld(spielFeld);
        int x, y;
        gebeKoordinateEin(&x, &y);
        if (istKoordinateGueltig(x, y))
        {
            char symbol = sucheSchiffe(flotte, x, y);
            eintragen(spielFeld, x, y, symbol);
            spielEnde = istSpielGewonnen(flotte);
        }
        else
        {
            spielEnde = true;
        }
    }
    while (!spielEnde);
}

