package de.willemer.quiz;

import android.content.Context;
import android.util.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class Quiz implements Serializable {
    private static final String TAG = "Quiz";
    private static final String dateiname = "quiz";

    private ArrayList<QuizAufgabe> aufgaben = new ArrayList<>();
    private int aufgPos = 0;

    public Quiz() {
    }

    public void fuelleMitTestdaten() {
        aufgaben.clear();
        aufgaben.add(new QuizAufgabe(0, "Wer sagte: Hier stehe ich, ich kann nicht anders?",
                new ArrayList<>(Arrays.asList(new String[]{
                        "Martin Luther", "VW Käfer", "Galileo", "Julius Caesar"
                }))));
        aufgaben.add(new QuizAufgabe(2, "Wer belegte die ersten drei Plätze der US-Top 10",
                new ArrayList<>(Arrays.asList(new String[]{
                        "Beethoven", "Elvis Presley", "The Beatles", "The Monkees"
                }))));
    }

    public void next() {
        aufgPos++;
        if (aufgPos >= aufgaben.size()) {
            aufgPos = 0;
        }
    }

    public QuizAufgabe getAufgabe() {
        if (aufgaben.size() == 0) {
            return null; // keine Aufgabe vorhanden
        }
        if (aufgPos >= aufgaben.size()) {
            aufgPos = 0;
        }
        return aufgaben.get(aufgPos);
    }

    public QuizAufgabe getAufgabe(int nr) {
        if (nr < aufgaben.size() && aufgaben.size() > 0) {
            return aufgaben.get(nr);
        } else {
            return getAufgabe();
        }
    }

    public int getAufgabeNr() {
        return aufgPos;
    }

    public void loescheAktuelleAufgabe() {
        if (aufgaben.size()>1) {
            aufgaben.remove(aufgPos);
        }
    }

    public void sichereInDatei(Context context) {
        try {
            FileOutputStream fos = context.openFileOutput(dateiname, Context.MODE_PRIVATE);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            os.writeObject(this);
            fos.close();
        } catch (FileNotFoundException e) {
            Log.d(TAG, "FileNotFound: "+e.toString());
        } catch (IOException e) {
            Log.d(TAG, "IOException: "+e.toString());
        }
    }

    public void add(QuizAufgabe quizAufgabe) {
        this.aufgaben.add(quizAufgabe);
    }

    public void leseAusDatei(Context context) {
        Quiz lokalQuiz = null;
        try {
            FileInputStream fis = context.openFileInput(dateiname);
            ObjectInputStream is = new ObjectInputStream(fis);
            lokalQuiz = (Quiz) is.readObject();
            is.close();
        } catch (FileNotFoundException e) {
            Log.d(TAG, e.getMessage());
            fuelleMitTestdaten();
        }
        catch (ClassNotFoundException e) {  // undenkbar
        }
        catch (IOException e) {
            Log.d(TAG, e.getMessage());
            fuelleMitTestdaten();
        }
        if (lokalQuiz != null) {
            aufgaben = lokalQuiz.aufgaben;
            aufgPos = lokalQuiz.aufgPos;

        }
    }

//    public static Quiz createFromJson(String jsonStr) {
//        Quiz quiz = new Quiz();
//        if (jsonStr != null) {
//            try {
//                JSONObject jsonObj = new JSONObject(jsonStr);
//                JSONArray aufgaben = jsonObj.getJSONArray("quiz");
//                for (int i = 0; i < aufgaben.length(); i++) {
//                    String frage = jsonObj.getString("frage");
//                    int richtig = jsonObj.getInt("richtig");
//                    ArrayList<String> array = new ArrayList<>();
//                    JSONArray antworten = jsonObj.getJSONArray("antwort");
//                    for (int j = 0; j < antworten.length(); j++) {
//                        array.add(antworten.getString(j));
//                    }
//                    quiz.add(new QuizAufgabe(richtig, frage, array));
//                }
//            } catch (JSONException e) {
//                Log.e(TAG, "Json parsing error: " + e.getMessage());
//            }
//        }
//        return quiz;
//    }

    public void createFromJson(String jsonStr) {
        this.aufgaben.clear();
        if (jsonStr != null) {
            try {
                JSONObject jsonObj = new JSONObject(jsonStr);
                JSONArray aufgaben = jsonObj.getJSONArray("quiz");
                for (int i = 0; i < aufgaben.length(); i++) {
                    JSONObject aufgabe = aufgaben.getJSONObject(i);
                    String frage = aufgabe.getString("frage");
                    int richtig = aufgabe.getInt("richtig");
                    ArrayList<String> array = new ArrayList<>();
                    JSONArray antworten = aufgabe.getJSONArray("antwort");
                    for (int j = 0; j < antworten.length(); j++) {
                        array.add(antworten.getString(j));
                    }
                    this.add(new QuizAufgabe(richtig, frage, array));
                }
                this.aufgPos = 0;
            } catch (JSONException e) {
                Log.e(TAG, "Json parsing error: " + e.getMessage());
            }
        }
    }

    public String getJsonString() {
        JSONObject jsonQuiz = new JSONObject();
        JSONArray jsonAufgArray = new JSONArray();
        try {
            for (int i = 0; i < this.aufgaben.size(); i++) {
                JSONObject jsonAufg = new JSONObject();
                jsonAufg.put("frage", aufgaben.get(i).getFrage());
                jsonAufg.put("richtig", aufgaben.get(i).getRichtig());
                JSONArray jsonAntwortArray = new JSONArray(getAufgabe(i).getAntworten());
                jsonAufg.put("antworten", jsonAntwortArray);
                jsonAufgArray.put(jsonAufg);
            }
            jsonQuiz.put("quiz", jsonAufgArray);
        } catch (JSONException e) {
        }
        return jsonQuiz.toString();
    }
}
