package de.willemer.quiz;

import android.util.Log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class HttpClient {
    private static final String TAG = "HttpClient";

    public String doGet(String url) {
        String empfangen = "";
        try {
            HttpURLConnection http = (HttpURLConnection)
                    new URL(url).openConnection();
            http.setRequestProperty("Accept-Charset", "UTF-8");
            http.setRequestProperty("Accept", "application/json");

            http.setRequestMethod("GET");
            // InputStream aus Verbindung bauen
            InputStream inStream = http.getInputStream();
            // Input-Stream könnte per read in ein Array gelesen
            // werden. Eleganter ist allerdings ein BufferedReader
            InputStreamReader isr = new InputStreamReader(inStream);
            BufferedReader in = new BufferedReader(isr);
            // In antwort werden die eingelesenen Zeilen gesammelt
            StringBuffer antwort = new StringBuffer();
            String empfangeneZeile; // für jede Zeile
            // Lese zeilenweise ..,
            while ((empfangeneZeile = in.readLine()) != null) {
                antwort.append(empfangeneZeile + "\n");
            }
            in.close(); // Stream schließen und damit die Verbindung
            empfangen = antwort.toString();
        } catch (MalformedURLException e) {
            Log.d(TAG, e.toString());
        } catch (ProtocolException e) {
            Log.d(TAG, e.toString());
        } catch (IOException e) {
            Log.d(TAG, e.toString());
        }
        return empfangen;
    }
}
