package de.willemer.quiz;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Spinner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class ChangeActivity extends AppCompatActivity implements View.OnClickListener {

    private Quiz quiz = null;   // wird in onResume aus der Datei gelesen
    private QuizAufgabe aufgabe = null;     // wird in onResume vorgelegt
    private int nrEdAntwort = -1;

    private EditText edAntwort = null;
    private EditText edFrage = null;
    //private ListView listView = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_change);
        Button bt = (Button)findViewById(R.id.btChgAntwort);
        bt.setOnClickListener(this);
        Button btOk = (Button)findViewById(R.id.btChgOk);
        btOk.setOnClickListener(this);
        edAntwort = (EditText) findViewById(R.id.edChgAntwort);
        edFrage = (EditText) findViewById(R.id.edChgFrage);
    }

    private void zeigeAufgabe() {
        if (aufgabe == null) {
            // keine Aufgabe übergeben, füge eine hinzu
            Intent ai=new Intent(this, AddActivity.class);
            startActivity(ai);
        }
        edFrage.setText(aufgabe.getFrage());
        // Baue die Liste
        ArrayList<String> antworten = aufgabe.getAntworten();
        final ArrayAdapter adapter = new ArrayAdapter(this,
                android.R.layout.simple_list_item_1, antworten);
        ListView listView = (ListView)findViewById(R.id.listChg);
        listView.setAdapter(adapter);
        // Auswahl wird in das Bearbeiten-Feld übernommen
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView listView, View view, int position, long id) {
                // Listenelement wurde ausgewählt
                edAntwort.setText(aufgabe.getAntwort(position));
                edAntwort.setEnabled(true); // falls es zuvor disabled war
                nrEdAntwort = position;
            }
        });
        if (antworten.size()>0) {
            edAntwort.setEnabled(true);
            edAntwort.setText(antworten.get(0));
        } else {
            edAntwort.setEnabled(false);
        }
        ArrayList<String> spinInhalt = new ArrayList<>();
        for (int i=0; i<antworten.size(); i++) {
            spinInhalt.add(""+(i+1));
        }
        ArrayAdapter spinAdapter = new ArrayAdapter(this, android.R.layout.simple_spinner_dropdown_item, spinInhalt);
        Spinner sp = (Spinner) findViewById(R.id.spChgRichtig);
        sp.setSelection(aufgabe.getRichtig());
        sp.setAdapter(spinAdapter);
        // Setze die zuletzt ausgesuchte Antwort in das Eingabefeld
        if (nrEdAntwort>=0) {
            edAntwort.setText(antworten.get(nrEdAntwort));
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        quiz = new Quiz();
        quiz.leseAusDatei(this);
        aufgabe = quiz.getAufgabe();
        zeigeAufgabe();
    }

    @Override
    protected void onPause() {
        super.onPause();
        quiz.sichereInDatei(this);
    }

    @Override
    public void onClick(View view) {
        switch(view.getId()) {
            case R.id.btChgAntwort:
                if (nrEdAntwort>=0) {
                    String antwort = edAntwort.getText().toString();
                    ArrayList<String> antworten = aufgabe.getAntworten();
                    antworten.set(nrEdAntwort, antwort);
                    zeigeAufgabe(); // baue die Liste neu auf
                }
                break;
            case R.id.btChgOk:
                String frage = edFrage.getText().toString();
                aufgabe.setFrage(frage);
                Spinner sp = (Spinner) findViewById(R.id.spChgRichtig);
                int richtigeAntwort = sp.getSelectedItemPosition();
                aufgabe.setRichtig(richtigeAntwort);
                Intent intent = new Intent(this, AskActivity.class);
                startActivity(intent);
                break;
        }
    }
}