package de.willemer.quiz;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;

import android.Manifest;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class AskActivity extends AppCompatActivity  {

    private static final String TAG = "AskActivity";

    private Quiz quiz = null;
    private final int writeExtId = 120;
    private final int readExtId = 121;
    private final int internetId = 122;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ask);
        // -- Variante SharedPreferences --
        SharedPreferences pref = getSharedPreferences("quiz", 0);
        String name = pref.getString("username", "");
        // -- Variante Intent-Extra auslesen --
        // Intent intent = getIntent();
        // String name = intent.getStringExtra("username");
        TextView tv = (TextView) findViewById(R.id.tvGruss);
        tv.setText(name);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.menue, menu);
        return true;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        String errStr = "no error";
        switch (item.getItemId()) {
            case R.id.mnNeu:
                Log.d(TAG, "Neu");
                Intent ai = new Intent(AskActivity.this, AddActivity.class);
                startActivity(ai);
                return true;
            case R.id.mnChange:
                Log.d(TAG, "Ändern");
                int frageNr = quiz.getAufgabeNr();
                Intent ci = new Intent(AskActivity.this, ChangeActivity.class);
                ci.putExtra("fragenummer", frageNr);
                startActivity(ci);
                return true;
            case R.id.mnDelete:
                Log.d(TAG, "Löschen");
                quiz.loescheAktuelleAufgabe();
                quiz.next();
                zeigeAufgabe();
                return true;
            case R.id.mnJsonSave:
                if (hatExtSchreibErlaubnis()) {
                    String jsonStr = quiz.getJsonString();
                    schreibeInDatei("quiz.json", jsonStr);
                } else {
                    starteBerechtigungsDialog(writeExtId);
                }
                return true;
            case R.id.mnJsonLoad:
                if (hatExtLeseErlaubnis()) {
                    String str = this.leseAusDatei("quiz.json");
                    quiz.createFromJson(str);
                } else {
                    starteBerechtigungsDialog(readExtId);
                }
                return true;
            case R.id.mnHttpReceive:
                if (hatInternetErlaubnis()) {
                    GetHttpTask task = new GetHttpTask(this);
                    task.start();
//                HttpClient client = new HttpClient();
//                String jsonStr = client.doGet("http://www.willemer.de/json/quiz.json");
//                quiz.createFromJson(jsonStr);
//                zeigeAufgabe();
                } else {
                    starteBerechtigungsDialog(internetId);
                }
                return true;
            case R.id.mnReset:
                quiz.fuelleMitTestdaten();
                zeigeAufgabe();
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    private void starteBerechtigungsDialog(int id) {
        ActivityCompat.requestPermissions(this,
                new String[]{
                Manifest.permission.READ_EXTERNAL_STORAGE,
                Manifest.permission.WRITE_EXTERNAL_STORAGE,
                Manifest.permission.INTERNET
                },
                id);
    }

    private boolean hatExtLeseErlaubnis() {
        return (ActivityCompat.checkSelfPermission(this,
                 Manifest.permission.READ_EXTERNAL_STORAGE)
                == PackageManager.PERMISSION_GRANTED);
    }

    private boolean hatExtSchreibErlaubnis() {
         return (ActivityCompat.checkSelfPermission(this,
                 Manifest.permission.WRITE_EXTERNAL_STORAGE)
                == PackageManager.PERMISSION_GRANTED);
    }

    private boolean hatInternetErlaubnis() {
        return (ActivityCompat.checkSelfPermission(this,
                Manifest.permission.INTERNET)
                == PackageManager.PERMISSION_GRANTED);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
               String[] permissions, int[] grantResults) {
        switch(requestCode) {
        case readExtId:
            if (hatExtLeseErlaubnis()) {
                String str = this.leseAusDatei("quiz.json");
                quiz.createFromJson(str);
            }
            break;
        case writeExtId:
            if (hatExtSchreibErlaubnis()) {
                String jsonStr = quiz.getJsonString();
                schreibeInDatei("quiz.json", jsonStr);
            }
            break;
        case internetId:
            GetHttpTask task = new GetHttpTask(this);
            task.start();
            break;
        }
        super.onRequestPermissionsResult(requestCode,
                permissions, grantResults);
    }

    public void httpCallback(String json) {
        quiz.createFromJson(json);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                zeigeAufgabe();
            }
        });
    }

    private void schreibeInDatei(String dateiname, String jsonStr) {
        File root = Environment.getExternalStorageDirectory();
//                File dir = new File (root.getAbsolutePath() + "/quiz");
//                dir.mkdirs();
        File file = new File(root, dateiname);
//                if (file.exists()) {
//                    file.delete();
//                }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter writer = new OutputStreamWriter(fos);
            writer.write(jsonStr);
            fos.close();
        } catch (FileNotFoundException e) {
            Log.e(TAG, e.toString());
        } catch (IOException e) {
            Log.e(TAG, e.toString());
        }
    }

    private String leseAusDatei(String dateiname) {
        String inhalt = "";
        File root = Environment.getExternalStorageDirectory();
        File file = new File(root, dateiname);
                try {
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(fis);
            BufferedReader bufread = new BufferedReader(reader);

            String zeile;
            while ((zeile = bufread.readLine()) != null) {
                inhalt += zeile;
            }
            fis.close();
        } catch (FileNotFoundException e) {
            Log.e(TAG, e.toString());
        } catch (IOException e) {
            Log.e(TAG, e.toString());
        }
        return inhalt;
    }
    @Override
    protected void onResume() {
        super.onResume();
        quiz = new Quiz();
        quiz.leseAusDatei(this);
        // quiz.fuelleMitTestdaten();
        zeigeAufgabe();
    }

    @Override
    protected void onPause() {
        super.onPause();
        quiz.sichereInDatei(this);
    }

    private void zeigeAufgabe() {
        TextView tvFrage = (TextView) findViewById(R.id.tvFrage);
        QuizAufgabe frage = quiz.getAufgabe();
        if (frage == null) {
            tvFrage.setText("Keine Frage, keine Antwort");
            return;
        }
        tvFrage.setText(frage.getFrage());
        // Baue die Liste
        ArrayList<String> antworten = frage.getAntworten();
        ArrayAdapter adapter = new ArrayAdapter(this,
                android.R.layout.simple_list_item_1, antworten);
        ListView listView = (ListView)findViewById(R.id.askList);
        listView.setAdapter(adapter);

        // Auswahl durch den Benutzer bearbeiten
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView listView, View view, int position, long id) {
                // Listenelement wurde ausgewählt
                if (position == frage.getRichtig()) {
                    quiz.next();
                    Intent intent = new Intent(AskActivity.this, RightActivity.class);
                    startActivity(intent);
                } else {
                    quiz.next();
                    Intent intent = new Intent(AskActivity.this, WrongActivity.class);
                    // Übergebe die korrekte Antwort
                    intent.putExtra("antwort",
                            frage.getAntwort(
                                    frage.getRichtig()));
                    startActivity(intent);  // Starte die Behandlung der falschen Antwort
                }
            }
        });

    }

    /**
     * Sichere den Zustand dieser Activity, insbesondere den Quiz-Stand
     * @param state das Bundle, in dem gespeichert werden soll
     */
    @Override
    protected void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        state.putSerializable("quiz", quiz);
    }
}