package de.willemer.quiz;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.Spinner;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class AddActivity extends AppCompatActivity implements View.OnClickListener {

    private Quiz quiz = null;   // wird in onResume bestimmt
    private ArrayList<String> antworten = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_change);
        Button bt = (Button) findViewById(R.id.btChgAntwort);
        bt.setOnClickListener(this);
        Button btOk = (Button) findViewById(R.id.btChgOk);
        btOk.setOnClickListener(this);
    }

    private void zeigeAufgabe() {
        // Fülle die Liste
        final ArrayAdapter adapter = new ArrayAdapter(this,
                android.R.layout.simple_list_item_1, antworten);
        ListView listView = (ListView)findViewById(R.id.listChg);
        listView.setAdapter(adapter);
        // Fülle den Spinner
        ArrayList<String> spinInhalt = new ArrayList<>();
        for (int i=0; i<antworten.size(); i++) {
            spinInhalt.add(""+(i+1));
        }
        ArrayAdapter spinAdapter = new ArrayAdapter(this, android.R.layout.simple_spinner_dropdown_item, spinInhalt);
        Spinner sp = (Spinner) findViewById(R.id.spChgRichtig);
        sp.setAdapter(spinAdapter);
    }

    @Override
    protected void onResume() {
        super.onResume();
        quiz = new Quiz();
        quiz.leseAusDatei(this);
        zeigeAufgabe();
    }

    @Override
    protected void onPause() {
        super.onPause();
        quiz.sichereInDatei(this);
    }

    @Override
    public void onClick(View view) {
        switch(view.getId()) {
            case R.id.btChgAntwort:
                EditText edAntwort = (EditText) findViewById(R.id.edChgAntwort);
                String antwort = edAntwort.getText().toString();
                antworten.add(antwort);
                zeigeAufgabe(); // baue die Liste neu auf
                break;
            case R.id.btChgOk:
                EditText edFrage = (EditText) findViewById(R.id.edChgFrage);
                String frage = edFrage.getText().toString();
                Spinner sp = (Spinner) findViewById(R.id.spChgRichtig);
                int richtigeAntwort = sp.getSelectedItemPosition();
                QuizAufgabe quizAufgabe = new QuizAufgabe(richtigeAntwort, frage, antworten);
                quiz.add(quizAufgabe);
                Intent intent = new Intent(this, AskActivity.class);
                startActivity(intent);
                break;
        }
    }
}