package de.willemer.minesweeper;

public class MinesweeperSpiel extends Anzeige {

	private int X = 4;
	private int Y = 6;
	private int MINEN = 3;
	private boolean verloren = false;
	private boolean gewonnen = false;

	private Minenfeld minen = null;

	MinesweeperSpiel(int anzminen, int x, int y) {
		super(x, y);
		minen = new Minenfeld(anzminen, x, y);
		X = x;
		Y = y;
		MINEN = anzminen;
		minen = new Minenfeld(MINEN, X, Y);
		verloren = false;
		gewonnen = false;
	}

	public void klick(int x, int y) {
		char c = minen.suche(new Koordinate(x, y));
		fuelleFeld(x, y, c);
		if (c==TREFFER) {
			if ( ! gewonnen ) {
				verloren = true;
			}
		} else if (c=='0') {
			deckeNachbarAuf(x, y);
		} 
		if (unaufgedeckt()==MINEN) {
			if ( ! verloren ) {
				gewonnen = true;
			}
		}
	}

	private void deckeNachbarAuf(int px, int py) {
		// setze x und y nacheinander auf die Nachbarfelder
		for (int dx=-1; dx<2; dx++) {
			for (int dy=-1; dy<2; dy++) {
				int x = px + dx;
				int y = py + dy;
				// Prüfe, ob der Rand überschritten wurde
				if (x>=0 && y>=0 && x<X && y<Y) {
					// Prüfe auf Unberührtheit
					if (holeFeld(x, y)==UNGEKLICKT) {
						// Löse die Rekursion aus
						klick(x, y);
					}
				}
			}
		}
	}
	

	public boolean gewonnen() {
		return this.gewonnen;
	}

	public boolean verloren() {
		return this.verloren;
	}
}
