package de.willemer.minesweeper;

public class Minenfeld {

	private Koordinate [] minen;

	public Minenfeld(int anzahl, int x, int y) {
		minen = new Koordinate[anzahl];
		java.util.Random zufall = new java.util.Random();
		for (int i=0; i<anzahl; i++) {
			minen[i] = new Koordinate(zufall.nextInt(x), zufall.nextInt(y));
			for (int j=0; j<i; j++) {
				if (minen[j].equals(minen[i])) {
					i--;
				}
			}
		}
	}

	public char suche(Koordinate koord) {
		char rueckgabe = '0';
		boolean treffer = false;
		for (int i = 0; i< minen.length; i++) {
			if (minen[i].equals(koord)) {
				treffer = true;
			} else {
				if (minen[i].istNachbar(koord)) {
					rueckgabe++;
				}
			}
		}
		if (treffer) {
			rueckgabe = Anzeige.TREFFER;
		}
		return rueckgabe;
	}
}
