package de.willemer.minesweeper;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;

/**
 * TODO: document your custom view class.
 */
public class MineSweeperView extends View implements View.OnTouchListener {
    static private int anzSpalten = 8;
    static private int anzZeilen = 10;
    static private int anzMinen = 12;

    static private MinesweeperSpiel spiel = new MinesweeperSpiel(anzMinen, anzSpalten, anzZeilen);
    static private boolean gestartet = false;
    private boolean markiere = false;

    public MineSweeperView(Context context) {
        super(context);
        this.setOnTouchListener(this);
    }

    public MineSweeperView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOnTouchListener(this);
    }

    public MineSweeperView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOnTouchListener(this);
    }

    int xOffset, yOffset, xDistanz, yDistanz;

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Paint paint = new Paint(); // Der Zeichenstift

        paint.setColor(Color.WHITE);
        if (spiel.verloren()) {
            paint.setColor(Color.RED);
        }
        if (spiel.gewonnen()) {
            paint.setColor(Color.YELLOW);
        }
        canvas.drawRect(0,0,getWidth(),getHeight(), paint);
        paint.setColor(Color.BLACK);

        int breite = getWidth() - 2*getPaddingStart();
        int hoehe = getHeight() - 2*getPaddingTop();

        xDistanz = breite / anzSpalten; // Abstandberechnung
        yDistanz = hoehe / anzZeilen;
        if (xDistanz < yDistanz) {
            yDistanz = xDistanz;
        } else {
            xDistanz = yDistanz;
        }
        xOffset = (getWidth() - anzSpalten*xDistanz) / 2;
        yOffset = (getHeight() - anzZeilen*yDistanz) / 2;

        paint.setStrokeWidth(2.0f);
        for (int i = 0; i < anzZeilen + 1; i++) { // Zeichne waagerechte Linien
            canvas.drawLine(xOffset, yOffset + i * yDistanz,
                    xOffset + anzSpalten*xDistanz, yOffset + i * yDistanz, paint);
        }
        for (int i = 0; i < anzSpalten + 1; i++) { // Zeichne senkrechte Linien
            canvas.drawLine(xOffset + i * xDistanz, yOffset,
                    xOffset + i * xDistanz, yOffset + anzZeilen * yDistanz, paint);
        }
        for (int x = 0; x < anzSpalten; x++) {
            for (int y = 0; y < anzZeilen; y++) {
                paint.setTextSize(yDistanz-4);
//                String str = "" + anzeige.holeFeld(x, y);
                String str = "" + spiel.holeFeld(x, y);
                canvas.drawText(str, xOffset + 2 + x * xDistanz, yOffset - 2 + (y+1) * yDistanz, paint);
            }
        }
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        // Die Methode wird aufgerufen, wenn der Tatsch gedrückt
        // und wenn er wieder losgelassen wird. Das wird beim
        // Markieren dazu führen, dass erst markiert und dann
        // demarkiert wird.
        if (motionEvent.getAction()==MotionEvent.ACTION_UP) {
            float posx = motionEvent.getX();
            float posy = motionEvent.getY();

            int logX = (int) (posx - xOffset) / xDistanz;
            int logY = (int) (posy - yOffset) / yDistanz;
            if (logX>=0 && logX<anzSpalten && logY>=0 && logY<anzZeilen) {

                if ( ! gestartet) {
                    gestartet = true;
                    listener.onGameStart();
                }
                if (markiere) {
                    spiel.markiere(logX, logY);
                } else {
                    spiel.klick(logX, logY);
                    if (spiel.gewonnen() && listener != null) {
                        listener.onGameOver(true);
                    }
                    if (spiel.verloren() && listener != null) {
                        listener.onGameOver(false);
                    }
                }
                invalidate(); // sonst sieht man kein Ergebnis.
            }
        }
        return true; // Verarbeitung erfolgt hier.
    }

    public void setMarkiere(boolean b) {
        markiere = b;
    }

    public void neuesSpiel() {
        spiel = new MinesweeperSpiel(anzMinen, anzSpalten, anzZeilen);
        invalidate();
        gestartet = false;
        // listener.onGameOver(false);
    }

    OnMineSweeperListener listener = null;

    public void setOnMineSweeperListener(OnMineSweeperListener onMineSweeperListener) {
        listener = onMineSweeperListener;
    }
}