package de.willemer.minesweeper;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.Chronometer;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Locale;

public class MainActivity extends AppCompatActivity implements OnMineSweeperListener {

    private long time = 0;
    private HighscoreSQLHelper db;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        CheckBox cbMark = (CheckBox) findViewById(R.id.cbMarkiere);
        cbMark.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                 MineSweeperView view = (MineSweeperView) findViewById(R.id.mineSweeperView);
                 view.setMarkiere(b);
            }
        });
        Button btNeuesSpiel = (Button) findViewById(R.id.btNewGame);
        btNeuesSpiel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                MineSweeperView msView = (MineSweeperView) findViewById(R.id.mineSweeperView);
                msView.neuesSpiel();
                Chronometer chro = (Chronometer) findViewById(R.id.tvTick);
                chro.setBase(SystemClock.elapsedRealtime());
                chro.stop();
            }
        });
        MineSweeperView mivi = (MineSweeperView) findViewById(R.id.mineSweeperView);
        mivi.setOnMineSweeperListener(this);
        Chronometer chro = (Chronometer) findViewById(R.id.tvTick);
//        chro.start();
        chro.setOnChronometerTickListener(new Chronometer.OnChronometerTickListener() {
            @Override
            public void onChronometerTick(Chronometer chronometer) {
                time++;
            }
        });
        db = new HighscoreSQLHelper(this);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.minemenu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.mnHighscore) {
            Toast.makeText(this, "Highscore geklickt", Toast.LENGTH_LONG).show();
            Intent intent = new Intent(this, HighscoreActivity.class);
            startActivity(intent);
            return true;
        } else if (id == R.id.mnMark) {
            CheckBox cbMark = (CheckBox) findViewById(R.id.cbMarkiere);
            cbMark.setChecked(! cbMark.isChecked());
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onGameOver(boolean won) {
        Chronometer chro = (Chronometer) findViewById(R.id.tvTick);
        chro.stop();
        if (won) {
            EditText edName = (EditText) findViewById(R.id.edName);
            String name = edName.getText().toString();
            // Datum und Uhrzeit ermitteln
            java.util.Date jetzt = new java.util.Date();
            SimpleDateFormat datumFormat =
                    new SimpleDateFormat("dd.MM.yyyy hh:mm");
            String datumString = datumFormat.format(jetzt);
            // Score in der Datenbank für den Highscore ablegen
            HighscoreSQLHelper db = new HighscoreSQLHelper(this);
            db.insert(name, time, datumString);
            db.close();
        }
    }

    @Override
    public void onGameStart() {
        TextView tv = (TextView) findViewById(R.id.tvTick);
        Chronometer chro = (Chronometer) findViewById(R.id.tvTick);
        chro.setBase(SystemClock.elapsedRealtime());
        time = 0;
        chro.start();
    }
}